% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sun.calc.r
\name{day_night}
\alias{day_length}
\alias{day_night}
\alias{night_length}
\alias{noon_time}
\alias{sunrise_time}
\alias{sunset_time}
\title{Times for sun positions}
\usage{
day_night(date = lubridate::today(), tz = "UTC", geocode = NULL,
  lon = 0, lat = 0, twilight = "none", unit.out = "date")

noon_time(date = lubridate::today(), tz = "UTC", geocode = NULL,
  lon = 0, lat = 0, twilight = NA, unit.out = "date")

sunrise_time(date = lubridate::today(), tz = "UTC", geocode = NULL,
  lon = 0, lat = 0, twilight = "none", unit.out = "date")

sunset_time(date = lubridate::today(), tz = "UTC", geocode = NULL,
  lon = 0, lat = 0, twilight = "none", unit.out = "date")

day_length(date = lubridate::today(), tz = "UTC", geocode = NULL,
  lon = 0, lat = 0, twilight = "none", unit.out = "hour")

night_length(date = lubridate::today(), tz = "UTC", geocode = NULL,
  lon = 0, lat = 0, twilight = "none", unit.out = "hour")
}
\arguments{
\item{date}{array of POSIXct times or Date objects, any valid TZ is allowed,
default is current date}

\item{tz}{character string incading time zone to be used in output, default
is system time zone}

\item{geocode}{data frame with variables lon and lat as numeric values
(degrees).}

\item{lon}{numeric array of longitudes (degrees)}

\item{lat}{numeric array of latitudes (degrees)}

\item{twilight}{character string, one of "none", "civil", "nautical",
"astronomical", or a \code{numeric} vector of length one, or two, giving
solar elevation angle(s) in degrees (negative if below the horizon).}

\item{unit.out}{charater string, One of "date", "hour", "minute", or "second".}
}
\value{
\code{day_night} returns a list with fields sunrise time, sunset
  time, day length, night length. Each element of the list is a vector of the
  same length as the argument supplied for date.

\code{noon_time}, \code{sunrise_time} and \code{sunset_time} return a
  vector of POSIXct times

\code{day_length} and \code{night_length} return numeric a vector
  giving the length in hours
}
\description{
Functions for calculating the timing of solar positions by means of function
\code{sun_angles}, given geographical coordinates and dates. They can be also
used to find the time for an arbitrary solar elevation between 90 and -90
degrees by supplying "twilight" angle(s) as argument.
}
\note{
If twilight is a numeric vector of length two, the element with index 1
  is used for sunrise and that with index 2 for sunset.

\code{night_length} returns the length of night-time conditions in one
  day (00:00:00 to 23:59:59), rather than the length of the night between two
  consequtive days.
}
\examples{
library(lubridate)
day_length()
day_length(ymd("2015-05-30"), lat = 60, lon = 25)
day_length(ymd("2014-12-30"), lat = 60, lon = 25)
day_length(ymd("2015-05-30"), lat = 60, lon = 25, twilight = "civil")
sunrise_time(ymd("2015-05-30"), lat = 60, lon = 25, tz = "EET")
day_night(ymd("2015-05-30"), lat = 60, lon = 25, twilight = "civil")

}
\seealso{
Other astronomy related functions: \code{\link{sun_angles}}
}

