% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color-wrappers.r
\name{spct_CCT}
\alias{spct_CCT}
\title{Correlated color temperature}
\usage{
spct_CCT(
  spct,
  isotherms = "robertson",
  locus = "robertson",
  strict = FALSE,
  named = FALSE
)
}
\arguments{
\item{spct}{source_spct A single light source spectrum.}

\item{isotherms}{character A vector whose elements match one of the available
isotherm families: 'robertson', 'mccamy', and 'native'. Matching is partial
and case-insensitive. When more than one family is given, a matrix is
returned, see Value. When isotherms = 'native' the isotherms are defined
implicitly as lines perpendicular to the locus, see Details in
\code{\link[spacesXYZ]{CCTfromXYZ}}. The character NA
(\code{NA_character_}) is taken as a synonym for 'native'.}

\item{locus}{character Valid values are 'robertson' and 'precision', see
above. Matching is partial and case-insensitive.}

\item{strict}{logical The CIE considers the CCT of a chromaticity uv to be
meaningful only if the distance from uv to the Planckian locus is less than
or equal to 0.05 (in CIE UCS 1960). If strict=FALSE, then this condition is
ignored. Otherwise, the distance is computed along the corresponding
isotherm, and if it exceeds 0.05 the returned CCT is set to NA.}

\item{named}{logical Whether to set the name attribute of the returned
value to the name of the spectrum passed as argument if possible.}
}
\value{
A numeric value for "color temperature " in degrees Kelvin.
}
\description{
Wrapper on function \code{\link[colorSpec]{computeCCT}} from package
'colorSpec' that accepts \code{\link[photobiology]{source_spct}} objects.
}
\details{
Please see \code{\link[colorSpec]{computeCCT}} for the details of
  the computations and references.
}
\examples{

spct_CCT(white_led.source_spct)
spct_CCT(sun.spct)

}
