% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flav.r
\name{FLAV}
\alias{FLAV}
\title{Constructor of FLAV BSWF flavonoids}
\usage{
FLAV(norm = 300, w.low = 275, w.high = 346)
}
\arguments{
\item{norm}{normalization wavelength (nm)}

\item{w.low}{short-end boundary wavelength (nm)}

\item{w.high}{long-end boundary wavelength (nm)}
}
\value{
a waveband object wavelength defining wavelength range, weighting function
and normalization wavelength.
}
\description{
Mesembryanthin accumulation BSWF, data and formulation from Ibdah et al.
}
\examples{
FLAV()
FLAV(300)

}
\seealso{
\code{\link[photobiology]{waveband}}

Other BSWF weighted wavebands: \code{\link{CH4}},
  \code{\link{CIE}}, \code{\link{DNA_GM}},
  \code{\link{DNA_N}}, \code{\link{DNA_P}},
  \code{\link{GEN_G}}, \code{\link{GEN_M}},
  \code{\link{GEN_T}}, \code{\link{ICNIRP}},
  \code{\link{PG}}
}
\concept{BSWF weighted wavebands}
