% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ir.r
\name{IR}
\alias{IR}
\alias{NIR}
\alias{IRA}
\alias{SWIR}
\alias{IRB}
\alias{SWIR1}
\alias{SWIR2}
\alias{MIR}
\alias{IRC}
\alias{FIR}
\alias{TIR1}
\alias{TIR2}
\title{Constructors of infra-red wavebands}
\usage{
IR(std = "ISO")

NIR(std = "ISO")

IRA(std = "CIE")

SWIR(std = "CIE")

IRB(std = "CIE")

SWIR1(std = "RS")

SWIR2(std = "RS")

MIR(std = "ISO")

IRC(std = "CIE")

FIR(std = "ISO")

TIR1(std = "RS")

TIR2(std = "RS")
}
\arguments{
\item{std}{character string, "ISO", "CIE", "RS" or Landsat imagers
"LandsatRBV", "LandsatMSS", "LandsatTIRS", "LandsatOLI", "LandsatTM",
"LandsatETM", depending on the constructor.}
}
\value{
A waveband object defining a wavelength range.
}
\description{
Wavelength-range definitions for \emph{infrared} radiation according to ISO,
CIE or as commonly defined in remote sensing applications.
}
\details{
The values for \code{std = "ISO"} are according to ISO 20473. The values for
\code{std = "CIE"} are suggested values according to Wikipedia, and need
verification.

The wavelength limits for remote sensing \code{std = "RS"} and for
Landsat imagers have been obtained from R package 'RStools' and NASA and USGS
documentation.

The names NIR, SWIR and TIR are abbreviations of near infra-red, short-wave
infra-red and thermal infra-red, respectively. The naming conventions are
different for "CIE" than "ISO" standards, and the labels of the waveband
objects reflect this with "IRA", "IRB", etc., used when appropriate.
}
\examples{
SWIR1()
SWIR1("RS")
IR()
NIR()
MIR()
IRA()
IRB()

}
\seealso{
\code{\link{Far_red}} for wavebands close to the boundary between red
  and infrared regions.

\code{\link{new_waveband}} and \code{\link{waveband}}

Other unweighted wavebands: 
\code{\link{Blue}()},
\code{\link{Far_red}()},
\code{\link{Green}()},
\code{\link{Orange}()},
\code{\link{Purple}()},
\code{\link{Red}()},
\code{\link{UVA}()},
\code{\link{UVB}()},
\code{\link{UVC}()},
\code{\link{UV}()},
\code{\link{VIS}()},
\code{\link{Yellow}()}
}
\concept{unweighted wavebands}
