% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_hyrda_vuln_curve.R
\name{fit_hydra_vuln_curve}
\alias{fit_hydra_vuln_curve}
\title{Fitting hydraulic vulnerability curves}
\usage{
fit_hydra_vuln_curve(
  data,
  varnames = list(psi = "psi", PLC = "PLC"),
  start_weibull = list(a = 2, b = 2),
  title = NULL
)
}
\arguments{
\item{data}{Dataframe}

\item{varnames}{List of variable names. varnames = list(psi = "psi",
PLC = "PLC") where psi is water potential in MPa, and PLC is percent
loss conductivity.}

\item{start_weibull}{starting values for the nls fitting routine
for the Weibull curve}

\item{title}{Title for the output graph}
}
\value{
fit_hydra_vuln_curve fits a sigmoidal function (Pammenter & Van der
Willigen, 1998) linearized according to Ogle et al. (2009). Output is a list
containing the sigmoidal model in element 1 and Weibull model in element 4,
the fit parameters with 95\% confidence interval for both models are in
element 2, and hydraulic parameters in element 3 (including P25, P50, P88,
P95, S50, Pe, Pmax, DSI). Px (25 to 95): water potential at which x\% of
conductivity is lost. S50: slope at 50\% loss of conductivity. Pe: air
entry point. Pmax: hydraulic failure threshold. DSI: drought stress interval.
Element 5 is a graph showing the fit, P50, Pe, and Pmax.
}
\description{
Fitting hydraulic vulnerability curves
}
\examples{
\donttest{
# Read in data
data <- read.csv(system.file("extdata", "hydraulic_vulnerability.csv",
  package = "photosynthesis"
))

# Fit hydraulic vulnerability curve
fit <- fit_hydra_vuln_curve(data[data$Tree == 4 & data$Plot == "Control", ],
  varnames = list(
    psi = "P",
    PLC = "PLC"
  ),
  title = "Control 4"
)

# Return Sigmoidal model summary
summary(fit[[1]])

# Return Weibull model summary
summary(fit[[4]])

# Return model parameters with 95\\% confidence intervals
fit[[2]]

# Return hydraulic parameters
fit[[3]]

# Return graph
fit[[5]]

# Fit many curves
fits <- fit_many(
  data = data,
  varnames = list(
    psi = "P",
    PLC = "PLC"
  ),
  group = "Tree",
  funct = fit_hydra_vuln_curve
)

# To select individuals from the many fits
# Return model summary
summary(fits[[1]][[1]]) # Returns model summary

# Return sigmoidal model output
fits[[1]][[2]]

# Return hydraulic parameters
fits[[1]][[3]]

# Return graph
fits[[1]][[5]]

# Compile parameter outputs
pars <- compile_data(
  data = fits,
  output_type = "dataframe",
  list_element = 3
)

# Compile graphs
graphs <- compile_data(
  data = fits,
  output_type = "list",
  list_element = 5
)
}
}
\references{
Ogle K, Barber JJ, Willson C, Thompson B. 2009. Hierarchical statistical
modeling of xylem vulnerability to cavitation. New Phytologist 182:541-554

Pammenter NW, Van der Willigen CV. 1998. A mathematical and statistical
analysis of the curves illustrating vulnerability of xylem to cavitation.
Tree Physiology 18:589-593
}
