\docType{data}
\name{ex4}
\alias{ex4}
\title{Example 4--Evaporation and Homogeneous Redox Reactions}
\source{
\url{http://wwwbrr.cr.usgs.gov/projects/GWC_coupled/phreeqc}
}
\description{
Evaporation is accomplished by removing water from the
chemical system. Water can be removed by several methods:
(1) water can be specified as an irreversible reactant with
a negative reaction coefficient in the REACTION keyword
input, (2) the solution can be mixed with pure water which
is given a negative mixing fraction in MIX, or (3) "H2O"
can be specified as the alternative reaction in
EQUILIBRIUM_PHASES keyword input, in which case water is
removed or added to the aqueous phase to attain equilibrium
with a specified phase. This example uses the first method;
the REACTION data block is used to simulate concentration
of rainwater by approximately 20-fold by removing 95
percent of the water. The resulting solution contains only
about 0.05 kg of water. In a subsequent simulation, the MIX
keyword is used to generate a solution that has the same
concentrations as the evaporated solution, but has a total
mass of water of approximately 1 kg. The example can be run
using the \code{\link{phrRunString}} routine.
}
\examples{
phrLoadDatabaseString(phreeqc.dat)
phrSetOutputStringsOn(TRUE)
phrRunString(ex4)
phrGetOutputStrings()
}
\references{
\url{http://pubs.usgs.gov/tm/06/a43/pdf/tm6-A43.pdf}
}
\seealso{
Other Examples: \code{\link{ex10}}; \code{\link{ex11}};
\code{\link{ex12}}; \code{\link{ex13a}},
\code{\link{ex13a}}, \code{\link{ex13b}},
\code{\link{ex13c}}; \code{\link{ex14}};
\code{\link{ex15}}; \code{\link{ex16}}; \code{\link{ex17}};
\code{\link{ex18}}; \code{\link{ex19}}; \code{\link{ex1}};
\code{\link{ex20a}}, \code{\link{ex20a}},
\code{\link{ex20b}}; \code{\link{ex21}};
\code{\link{ex22}}; \code{\link{ex2}}; \code{\link{ex3}};
\code{\link{ex5}}; \code{\link{ex6}}; \code{\link{ex7}};
\code{\link{ex8}}; \code{\link{ex9}}
}
\keyword{dataset}

