% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-phybreak.R
\name{plot.phybreak}
\alias{plot.phybreak}
\title{Plotting a phybreak object.}
\usage{
\method{plot}{phybreak}(x, plot.which = c("sample", "mpc", "mtcc", "mcc"),
  samplenr = 0, ...)
}
\arguments{
\item{x}{An object of class \code{phybreak}.}

\item{plot.which}{Either \code{"sample"} to plot the current state or a selected posterior sample, 
\code{"mpc"} or \code{"mtcc"} to plot a consensus transmission tree (see \code{\link{transtree}}) or \code{"mcc"}
to plot the maximum clade credibility tree (see \code{\link{phylotree}}).}

\item{samplenr}{If \code{plot.which = "sample"}, this indicates which posterior tree should be plotted: 
\code{samplenr = 0} to plot the current state.}

\item{...}{Additional options for \code{\link[phytools]{plotSimmap}}.}
}
\description{
Plots a \code{phybreak}-object as phylogenetic tree with coloured branches indicating hosts. The default 
  is to plot the current state, but any posterior sample can be chosen, as well as various consensus trees.
}
\examples{
#First build a phybreak-object containing samples.
simulation <- sim.phybreak(obsize = 5)
MCMCstate <- phybreak(data = simulation$sequences, times = simulation$sample.times)
MCMCstate <- burnin.phybreak(MCMCstate, ncycles = 20)
MCMCstate <- sample.phybreak(MCMCstate, nsample = 50, thin = 2)

plot(MCMCstate, plot.which = "mpc")
}
\author{
Don Klinkenberg \email{don@xs4all.nl}
}
\references{
\href{http://dx.doi.org/10.1101/069195}{Klinkenberg et al, on biorXiv}.
}

