% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_clades.R
\name{get_clades}
\alias{get_clades}
\title{Get descendant nodes of phylogeny at a given time depth}
\usage{
get_clades(tree, cut = NULL, k = NULL)
}
\arguments{
\item{tree}{is a dated phylogenetic tree with branch lengths stored
as a phylo object (as in the \code{ape} package).}

\item{cut}{the slice time}

\item{k}{number of slices}
}
\value{
A list of descendants
}
\description{
\code{get_clades} returns the tips that descend from a given node or time depth on a dated phylogenetic tree.
}
\examples{
require(ape)
data(bird.orders)
plot(bird.orders)
axisPhylo(side = 1)
abline(v=28-23) # the root is here at 28
get_clades(bird.orders, 23)
}
\references{
Schliep, K.P. (2010) phangorn: phylogenetic analysis in
R. \emph{Bioinformatics} \strong{27}: 592–593.
}
\keyword{bioregion}
