% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_input_data.R
\name{rast2comm}
\alias{rast2comm}
\alias{polys2comm}
\alias{points2comm}
\title{Convert raw input distribution data to community}
\usage{
rast2comm(files)

polys2comm(dat, res = 0.25, pol.grids = NULL, ...)

points2comm(dat, res = 0.25, pol.grids = NULL, ...)
}
\arguments{
\item{files}{list of SpatRaster layer objects with the same spatial
extent and resolution.}

\item{dat}{layers of merged maps corresponding to species polygons for
\code{polys2comm}; or point occurrence data frame for \code{points2comm},
with at least three columns:
\itemize{
  \item Column 1: \code{species} (listing the taxon names)
  \item Column 2: \code{decimallongitude} (corresponding to decimal longitude)
  \item Column 3: \code{decimallatitude} (corresponding to decimal latitude)
}}

\item{res}{the grain size of the grid cells in decimal degrees (default).}

\item{pol.grids}{if specified, the vector polygon of grid cells
with a column labeled \dQuote{grids}.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Each of these functions generate a list of two objects as follows:
\itemize{
  \item comm_dat: (sparse) community matrix
  \item map: vector or raster of grid cells with the values per cell for
  mapping.
}
}
\description{
The functions \code{points2comm}, \code{polys2comm}, \code{rast2comm}
provide convenient interfaces to convert raw distribution data often
available as point records, polygons and raster layers,
respectively, to a community composition data frame at varying spatial grains
and extents for downstream analyses.
}
\examples{
\donttest{
fdir <- system.file("NGAplants", package="phyloregion")
files <- file.path(fdir, dir(fdir))
ras <- rast2comm(files) # Note, this function generates
     # a list of two objects
head(ras[[1]])
}

\donttest{
require(terra)
s <- vect(system.file("ex/nigeria.json", package="phyloregion"))
sp <- random_species(100, species=5, pol=s)
pol <- polys2comm(dat = sp)
head(pol[[1]])
}

library(terra)
s <- vect(system.file("ex/nigeria.json", package="phyloregion"))
set.seed(1)
m <- as.data.frame(spatSample(s, 1000, method = "random"),
                   geom = "XY")[-1]
names(m) <- c("lon", "lat")
species <- paste0("sp", sample(1:100))
m$taxon <- sample(species, size = nrow(m), replace = TRUE)

pt <- points2comm(dat = m, res = 0.5) # This generates a list of two objects
head(pt[[1]])
}
\seealso{
\code{\link[mapproj]{mapproject}} for conversion of
latitude and longitude into projected coordinates system.
\code{\link{long2sparse}} for conversion of community data.
}
