% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-calc.R
\name{calc_mad}
\alias{calc_mad}
\title{Calculate MAD score}
\usage{
calc_mad(phylota, cid)
}
\arguments{
\item{phylota}{Phylota object}

\item{cid}{Cluster ID(s)}
}
\value{
vector
}
\description{
For all sequences in a cluster(s) the MAD score.
}
\details{
MAD is a measure of the deviation in sequence length of a cluster.
Values range from 0 to 1. Clusters with values close to 1 have sequences with
similar lengths.
}
\examples{
data("bromeliads")
random_cids <- sample(bromeliads@cids, 10)
(calc_mad(phylota = bromeliads, cid = random_cids))
}
\seealso{
Other tools-public: \code{\link{calc_wrdfrq}},
  \code{\link{drop_by_rank}}, \code{\link{drop_clstrs}},
  \code{\link{drop_sqs}}, \code{\link{get_clstr_slot}},
  \code{\link{get_nsqs}}, \code{\link{get_ntaxa}},
  \code{\link{get_sq_slot}}, \code{\link{get_stage_times}},
  \code{\link{get_tx_slot}}, \code{\link{get_txids}},
  \code{\link{is_txid_in_clstr}},
  \code{\link{is_txid_in_sq}},
  \code{\link{list_clstrrec_slots}},
  \code{\link{list_ncbi_ranks}},
  \code{\link{list_seqrec_slots}},
  \code{\link{list_taxrec_slots}},
  \code{\link{plot_phylota_pa}},
  \code{\link{plot_phylota_treemap}},
  \code{\link{read_phylota}}, \code{\link{write_sqs}}
}
