% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pglmm-utils.R
\name{pglmm.matrix.structure}
\alias{pglmm.matrix.structure}
\alias{communityPGLMM.matrix.structure}
\title{\code{pglmm.matrix.structure} produces the entire
covariance matrix structure (V) when you specify random effects.}
\usage{
pglmm.matrix.structure(formula, data = list(), family = "binomial",
  cov_ranef, repulsion = FALSE, ss = 1, cpp = TRUE)

communityPGLMM.matrix.structure(formula, data = list(),
  family = "binomial", cov_ranef, repulsion = FALSE, ss = 1,
  cpp = TRUE)
}
\arguments{
\item{formula}{A two-sided linear formula object describing the
mixed effects of the model.

To specify that a random term should have phylogenetic covariance matrix along
with non-phylogenetic one, add \code{__} (two underscores) at the end of the group variable;
e.g., \code{+ (1 | sp__)} will construct two random terms,
one with phylogenetic covariance matrix and another with non-phylogenetic (identity) matrix.
In contrast, \code{__} in the nested terms (below) will only create a phylogenetic covariance matrix.
Nested random terms have the general form \code{(1|sp__@site__)} which represents
phylogenetically related species nested within correlated sites.
This form can be used for bipartite questions. For example, species could be
phylogenetically related pollinators and sites could be phylogenetically related plants, leading to
the random effect \code{(1|insects__@plants__)}. If more than one phylogeny is used, remember to add
all to the argument \code{cov_ranef = list(insects = insect_phylo, plants = plant_phylo)}. Phylogenetic correlations can
be dropped by removing the \code{__} underscores. Thus, the form \code{(1|sp@site__)} excludes the phylogenetic
correlations among species, while the form \code{(1|sp__@site)} excludes the correlations among sites.

Note that correlated random terms are not allowed. For example,
\code{(x|g)} will be the same as \code{(0 + x|g)} in the \code{lme4::lmer} syntax. However,
\code{(x1 + x2|g)} won't work, so instead use  \code{(x1|g) + (x2|g)}.}

\item{data}{A \code{\link{data.frame}} containing the variables named in formula.}

\item{family}{Either "gaussian" for a Linear Mixed Model, or
"binomial" or "poisson" for Generalized Linear Mixed Models.
"family" should be specified as a character string (i.e., quoted). For binomial and
Poisson data, we use the canonical logit and log link functions, respectively.
Binomial data can be either presence/absence, or a two-column array of 'successes' and 'failures'.
For both binomial  and Poisson data, we add an observation-level
random term by default via \code{add.obs.re = TRUE}. If \code{bayes = TRUE} there are
two additional families available: "zeroinflated.binomial", and "zeroinflated.poisson",
which add a zero inflation parameter; this parameter gives the probability that the response is
a zero. The rest of the parameters of the model then reflect the "non-zero" part part
of the model. Note that "zeroinflated.binomial" only makes sense for success/failure
response data.}

\item{cov_ranef}{A named list of covariance matrices of random terms. The names should be the
group variables that are used as random terms with specified covariance matrices
(without the two underscores, e.g. \code{list(sp = tree1, site = tree2)}). The actual object
can be either a phylogeny with class "phylo" or a prepared covariance matrix. If it is a phylogeny,
\code{pglmm} will prune it and then convert it to a covariance matrix assuming Brownian motion evolution.
\code{pglmm} will also standardize all covariance matrices to have determinant of one. Group variables
will be converted to factors and all covariance matrices will be rearranged so that rows and
columns are in the same order as the levels of their corresponding group variables.}

\item{repulsion}{When there are nested random terms specified, \code{repulsion = FALSE} tests
for phylogenetic underdispersion while \code{repulsion = FALSE} tests for overdispersion.
This argument is a logical vector of length either 1 or >1.
If its length is 1, then all covariance matrices in nested terms will be either
inverted (overdispersion) or not. If its length is >1, then you can select
which covariance matrix in the nested terms to be inverted. Make sure to get
the length right: for all the terms with \code{@}, count the number of "__"
to determine the length of repulsion. For example, \code{sp__@site} and \code{sp@site__}
will each require one element of \code{repulsion}, while \code{sp__@site__} will take two
elements (repulsion for sp and repulsion for site). Therefore, if your nested terms are
\code{(1|sp__@site) + (1|sp@site__) + (1|sp__@site__)}, then you should set the
repulsion to be something like \code{c(TRUE, FALSE, TRUE, TRUE)} (length of 4).}

\item{ss}{Which of the \code{random.effects} to produce.}

\item{cpp}{Whether to use C++ function for optim. Default is TRUE. Ignored if \code{bayes = TRUE}.}
}
\value{
A design matrix.
}
\description{
\code{pglmm.matrix.structure} produces the entire
covariance matrix structure (V) when you specify random effects.
}
