% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.aggregation_structure.R
\name{update.piar_aggregation_structure}
\alias{update.piar_aggregation_structure}
\title{Update an aggregation structure}
\usage{
\method{update}{piar_aggregation_structure}(object, index, period = end(index), ..., r = 1)
}
\arguments{
\item{object}{A price index aggregation structure, as made by
\code{\link[=aggregation_structure]{aggregation_structure()}}.}

\item{index}{A price index, or something that can be coerced into one.
Usually an aggregate price index as made by
\code{\link[=aggregate.piar_index]{aggregate()}}.}

\item{period}{The time period used to price update the weights. The default
uses the last period in \code{index}.}

\item{...}{Not currently used.}

\item{r}{Order of the generalized mean to update the weights. The default is
1 for an arithmetic index.}
}
\value{
A copy of \code{object} with price-updated weights using the index
values in \code{index}.
}
\description{
Price update the weights in a price index aggregation structure.
}
\examples{
# A simple aggregation structure
#            1
#      |-----+-----|
#      11          12
#  |---+---|       |
#  111     112     121
#  (1)     (3)     (4)

aggregation_weights <- data.frame(
  level1 = c("1", "1", "1"),
  level2 = c("11", "11", "12"),
  ea     = c("111", "112", "121"),
  weight = c(1, 3, 4)
)

pias <- as_aggregation_structure(aggregation_weights)

index <- as_index(
  matrix(1:9, 3, dimnames = list(c("111", "112", "121"), NULL))
)

weights(pias, ea_only = FALSE)

weights(update(pias, index), ea_only = FALSE)

}
\seealso{
\code{\link[=aggregate.piar_index]{aggregate()}} to make an aggregated price index.

Other aggregation structure methods: 
\code{\link{as.matrix.piar_aggregation_structure}()},
\code{\link{levels.piar_aggregation_structure}()},
\code{\link{weights.piar_aggregation_structure}()}
}
\concept{aggregation structure methods}
