% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.piar_index.R
\name{[.piar_index}
\alias{[.piar_index}
\alias{[<-.piar_index}
\title{Extract and replace index values}
\usage{
\method{[}{piar_index}(x, i, j, ...)

\method{[}{piar_index}(x, i, j, ...) <- value
}
\arguments{
\item{x}{A price index, as made by, e.g., \code{\link[=elemental_index]{elemental_index()}}.}

\item{i, j}{Indices for the levels and time periods of a price index. See
details.}

\item{...}{Not currently used.}

\item{value}{A numeric vector or price index. See details.}
}
\value{
A price index that inherits from the same class as \code{x}.
}
\description{
Methods to extract and replace index values like a matrix.
}
\details{
The extraction method treats \code{x} like a matrix of index values with
(named) rows for each level and columns for each time period in
\code{x}. Unlike a matrix, dimensions are never dropped as subscripting
\code{x} always returns an index object. This means that subscripting with a
matrix is not possible, and only a "submatrix" can be extracted. As \code{x}
is not an atomic vector, subscripting with a single index like \code{x[1]}
extracts all time periods for that level.

The replacement method similarly treat \code{x} like a matrix. If \code{value} is
an index object with the same number of time periods as \code{x[i, j]} and
it inherits from the same class as \code{x}, then the index values and
percent-change contributions of \code{x[i, j]} are replaced with those for the
corresponding levels of \code{value}. If \code{value} is not an index, then it is
coerced to a numeric vector and behaves the same as replacing values in a
matrix. Note that replacing the values of an index will remove the
corresponding percent-change contributions (if any). Unlike extraction, it
is possible to replace value in \code{x} using a logical matrix or a two-column
matrix of indices.
}
\examples{
index <- as_index(matrix(1:6, 2))

index["1", ]

index[, 2]

index[1, ] <- 1 # can be useful for doing specific imputations

index

}
\seealso{
Other index methods: 
\code{\link{aggregate.piar_index}},
\code{\link{as.data.frame.piar_index}()},
\code{\link{as.ts.piar_index}()},
\code{\link{chain}()},
\code{\link{contrib}()},
\code{\link{head.piar_index}()},
\code{\link{is.na.piar_index}()},
\code{\link{levels.piar_index}()},
\code{\link{mean.piar_index}},
\code{\link{merge.piar_index}()},
\code{\link{split.piar_index}()},
\code{\link{stack.piar_index}()},
\code{\link{time.piar_index}()},
\code{\link{window.piar_index}()}
}
\concept{index methods}
