% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{remove_diacritics}
\alias{remove_diacritics}
\title{Remove Diacritical Marks on Characters}
\usage{
remove_diacritics(text)
}
\arguments{
\item{text}{A character vector to clean.}
}
\value{
The character vector with simpler character representations.
}
\description{
Accent characters and other diacritical marks are often difficult to type,
and thus can be missing from text. To normalize the various ways a user might
spell a word that should have a diacritical mark, you can convert all such
characters to their simpler equivalent character.
}
\examples{
# This text can appear differently between machines if we aren't careful, so
# we explicitly encode the desired characters.
sample_text <- "fa\u00e7ile r\u00e9sum\u00e9"
sample_text
remove_diacritics(sample_text)
}
