% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piecenorms-package.R
\docType{package}
\name{piecenorms-package}
\alias{piecenorms}
\alias{piecenorms-package}
\title{piecenorms: Calculate a Piecewise Normalised Score Using Class Intervals}
\description{
\code{piecenorms} has been built to calculate normalised data piecewise
using class intervals. This is useful in communication of highly skewed data.
}
\details{
For highly skewed data, the package \code{classInt} provides a series of options
for selecting class intervals. The \code{classInts} can be used as the breaks for
calculating the piecewise normalisation function \code{piecenorm}. The function
also allows the user to select their own breaks manually.

For any call to \code{piecenorm}, the user provides a vector of observations,
a vector of breaks and a direction for the normalisation. The data is then
cut into classes and normalised within its class.

Number of Bins:
\deqn{ n = \text{length}(\text{brks}) - 1}
Normalisation Class Intervals:
\deqn{\left(\frac{i-1}{n}, \frac{i}{n}\right] \forall i \in \{1:n\}}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/david-hammond/piecenorms}
  \item Report bugs at \url{https://github.com/david-hammond/piecenorms/issues}
}

}
\author{
\strong{Maintainer}: David Hammond \email{anotherdavidhammond@gmail.com}

}
