% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_print_and_play.R
\name{save_print_and_play}
\alias{save_print_and_play}
\title{Save piecepack print-and-play (PnP) file}
\usage{
save_print_and_play(
  cfg = getOption("piecepackr.cfg", pp_cfg()),
  output_filename = "piecepack.pdf",
  size = c("letter", "A4", "A5", "4x6"),
  pieces = NULL,
  arrangement = c("single-sided", "double-sided"),
  dev = NULL,
  dev.args = list(family = cfg$fontfamily, onefile = TRUE, units = "in", bg = "white",
    res = 72),
  quietly = FALSE,
  ...,
  bleed = FALSE
)
}
\arguments{
\item{cfg}{Piecepack configuration list or \code{pp_cfg} object}

\item{output_filename}{Filename for print-and-play file}

\item{size}{PnP output size (currently either "letter", "A4", "A5", or "4x6")
Size "4x6" currently only supports \code{pieces = "piecepack"}
and doesn't support \code{bleed = TRUE}.}

\item{pieces}{Character vector of desired PnP pieces.
Supports "piecepack", "matchsticks", "pyramids", "subpack", or "all".
If \code{NULL} and combination of \code{size} / \code{bleed} values supports "matchsticks" and "pyramids"
then defaults to \code{c("piecepack", "pyramids", "matchsticks")} else just "piecepack".}

\item{arrangement}{Either "single-sided" or "double-sided".
Ignored if \code{size = "4x6"}.}

\item{dev}{Graphics device function to use.  If \code{NULL} infer a reasonable choice.}

\item{dev.args}{Additional arguments to pass to \code{dev} (besides \code{filename}, \code{width}, and \code{height}).
Will filter out any names that aren't in \code{formals(dev)}.}

\item{quietly}{Whether to hide messages about missing metadata
in the provided configuration.}

\item{...}{Arguments to \code{\link[=pmap_piece]{pmap_piece()}}}

\item{bleed}{If \code{TRUE} produce a variant file with "bleed" zones
and "crop marks".
Currently only supports \code{pieces = "piecepack"} and doesn't
support \code{size = "4x6"}.}
}
\description{
Save piecepack print-and-play (PnP) file
}
\examples{
  \donttest{
    if (capabilities("cairo")) {
        cfg <- pp_cfg(list(invert_colors.suited=TRUE))
        cfg$description <- 'Piecepack with an "inverted" color scheme.'
        cfg$title <- '"Inverted" piecepack'
        cfg$copyright <- "\u00a9 2022 Trevor L Davis.  Some Right Reserved."
        cfg$spdx_id <- "CC-BY-4.0"
        cfg$credit <- ""
        save_print_and_play(cfg, "my_pnp_file.pdf")
        save_print_and_play(cfg, "my_pnp_file_ds.pdf", arrangement="double-sided")
        save_print_and_play(cfg, "my_pnp_file_A4.pdf", size="A4", pieces="all")
        save_print_and_play(cfg, "my_pnp_file_A5.pdf", size="A5")
        unlink("my_pnp_file.pdf")
        unlink("my_pnp_file_ds.pdf")
        unlink("my_pnp_file_A4.pdf")
        unlink("my_pnp_file_A5.pdf")
    }
  }
}
