% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_new_release.R
\name{pb_new_release}
\alias{pb_new_release}
\title{Create a new release on GitHub repo}
\usage{
pb_new_release(repo = guess_repo(), tag, commit = "master",
  name = tag, body = "Data release", draft = FALSE,
  prerelease = FALSE, .token = get_token())
}
\arguments{
\item{repo}{Repository name in format "owner/repo". Will guess
the current repo if not specified.}

\item{tag}{tag to create for this release}

\item{commit}{Specifies the commit-ish value that
determines where the Git tag is created from.
Can be any branch or commit SHA. Unused if the
git tag already exists. Default: the repository's
default branch (usually \code{master}).}

\item{name}{The name of the release. Defaults to tag.}

\item{body}{Text describing the contents of the tag.
default text is "Data release".}

\item{draft}{default \code{FALSE}. Set to \code{TRUE} to create
a draft (unpublished) release.}

\item{prerelease}{default \code{FALSE}. Set to \code{TRUE} to
identify the release as a pre-release.}

\item{.token}{GitHub authentication token. Typically set from an
environmental variable, e.g. in a \code{.Renviron} file or with
\code{Sys.setenv(GITHUB_TOKEN = "xxxxx")}, which helps prevent accidental
disclosure of a secret token when sharing scripts.}
}
\description{
Create a new release on GitHub repo
}
\examples{
\dontrun{
pb_new_release("cboettig/piggyback-tests", "v0.0.5")
}
}
