% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pillar-package.R
\docType{package}
\name{pillar-package}
\alias{pillar-package}
\title{pillar: Coloured Formatting for Columns}
\description{
\Sexpr[results=rd, stage=render]{pillar:::lifecycle("maturing")}
Provides \link{pillar} and \link{colonnade} generics designed for formatting columns
of data using the full range of colours provided by modern terminals.
}
\details{
See \code{\link[=pillar]{pillar()}} for formatting a single column,
and \code{\link[=colonnade]{colonnade()}} for formatting multiple columns passed as a data frame.
}
\section{Package options}{

\itemize{
\item \code{pillar.bold}: Use bold font, e.g. for column headers? This currently
defaults to \code{FALSE}, because many terminal fonts have poor support for
bold fonts.
\item \code{pillar.subtle}: Use subtle style, e.g. for row numbers and data types?
Default: \code{TRUE}.
\item \code{pillar.subtle_num}: Use subtle style for insignificant digits? Default:
\code{FALSE}, is also affected by the \code{pillar.subtle} option.
\item \code{pillar.neg}: Highlight negative numbers? Default: \code{TRUE}.
\item \code{pillar.sigfig}: The number of significant digits that will be printed and
highlighted, default: \code{3}. Set the \code{pillar.subtle} option to \code{FALSE} to
turn off highlighting of significant digits.
\item \code{pillar.min_title_chars}: The minimum number of characters for the column
title, default: \code{15}.  Column titles may be truncated up to that width to
save horizontal space. Set to \code{Inf} to turn off truncation of column
titles.
}
}

\examples{
pillar(1:3)
pillar(c(1, 2, 3))
pillar(factor(letters[1:3]), title = "letters")
colonnade(iris[1:3, ])
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/r-lib/pillar}
  \item Report bugs at \url{https://github.com/r-lib/pillar/issues}
}

}
\author{
\strong{Maintainer}: Kirill Müller \email{krlmlr+r@mailbox.org}

Authors:
\itemize{
  \item Hadley Wickham
}

Other contributors:
\itemize{
  \item RStudio [copyright holder]
}

}
