% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctl_pillar.R
\name{pillar}
\alias{pillar}
\title{Object for formatting a vector suitable for tabular display}
\usage{
pillar(x, title = NULL, width = NULL, ...)
}
\arguments{
\item{x}{A vector to format.}

\item{title}{An optional title for the column. The title will be
used "as is", no quoting will be applied.}

\item{width}{Default width, optional.}

\item{...}{Passed on to \code{\link[=pillar_shaft]{pillar_shaft()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{pillar()} creates an object that formats a vector.
The output uses one row for a title (if given), one row for the type,
and \code{vec_size(x)} rows for the data.
}
\details{
A pillar consists of arbitrary components.
The \code{pillar()} constructor uses \code{title}, \code{type}, and \code{data}.
\itemize{
\item \code{title} via \code{\link[=new_pillar_title]{new_pillar_title()}}
\item \code{type} via \code{\link[=new_pillar_type]{new_pillar_type()}}, which calls \code{\link[=type_sum]{type_sum()}}
internally
\item \code{data} via \code{\link[=pillar_shaft]{pillar_shaft()}}
}

All components are formatted via \code{\link[=format]{format()}} when displaying the pillar.
A \code{width} argument is passed to each \code{format()} call.

As of pillar 1.5.0, \code{pillar()} returns \code{NULL} if the width is insufficient
to display the data.
}
\examples{
x <- 123456789 * (10 ^ c(-1, -3, -5, NA, -8, -10))
pillar(x)
pillar(-x)
pillar(runif(10))
pillar(rcauchy(20))

# Special values are highlighted
pillar(c(runif(5), NA, NaN, Inf, -Inf))

# Very wide ranges will be displayed in scientific format
pillar(c(1e10, 1e-10), width = 20)
pillar(c(1e10, 1e-10))

x <- c(FALSE, NA, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, TRUE)
pillar(x)

x <- c("This is string is rather long", NA, "?", "Short")
pillar(x)
pillar(x, width = 30)
pillar(x, width = 5)

date <- as.Date("2017-05-15")
pillar(date + c(1, NA, 3:5))
pillar(as.POSIXct(date) + c(30, NA, 600, 3600, 86400))
}
