% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-sum.R
\name{type_sum}
\alias{type_sum}
\alias{obj_sum}
\alias{size_sum}
\title{Provide a succinct summary of an object}
\usage{
type_sum(x)

obj_sum(x)

size_sum(x)
}
\arguments{
\item{x}{an object to summarise. Generally only methods of atomic vectors
and variants have been implemented.}
}
\description{
\code{type_sum()} gives a brief summary of object type. Objects that commonly
occur in a data frame should return a string with four or less characters.
For most inputs, the argument is forwarded to \code{\link[vctrs:vec_ptype_full]{vctrs::vec_ptype_abbr()}}.

\code{obj_sum()} also includes the size (but not the shape) of the object
if \code{\link[vctrs:vec_assert]{vctrs::vec_is()}} is \code{TRUE}.
It should always return a string (a character vector of length one).
As of pillar v1.6.1, the default method forwards to \code{\link[vctrs:vec_ptype_full]{vctrs::vec_ptype_abbr()}}
for vectors and to \code{\link[=type_sum]{type_sum()}} for other objects.
Previous versions always forwarded to \code{\link[=type_sum]{type_sum()}}.

\code{size_sum()} is called by \code{obj_sum()} to format the size of the object.
It should always return a string (a character vector of length one),
it can be an empty string \code{""} to omit size information,
this is what the default method does for scalars.
}
\details{
When formatting a pillar,
\code{type_sum()} will be called on a slice of the column vector.
The formatted type should only depend on the type and not on the data,
to avoid confusion.
}
\examples{
obj_sum(1:10)
obj_sum(matrix(1:10))
obj_sum(Sys.Date())
obj_sum(Sys.time())
obj_sum(mean)

size_sum(1:10)
size_sum(trees)
size_sum(Titanic)
}
\keyword{internal}
