% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pim.environment-class.R
\docType{class}
\name{pim.environment-class}
\alias{pim.environment-class}
\alias{pim.environment}
\title{The pim.environment class}
\description{
This S4 class inherits from the S3 class \code{\link{environment}}.
The environment serves as a container to hold the data, poset and the
poset related functions of a probabilistic index model generated
by the function \code{\link{pim}}. The objects of this class
behave much like an environment, but contain some extra slots
with information on the objects inside the environment.
}
\section{Slots}{

\describe{
\item{\code{poset}}{an environment of class \code{\link{pim.poset}} containing the  poset-related functions
(normally these are \code{\link{L}} and \code{\link{R}}). This 
environment has the object itself as parent.}

\item{\code{data.names}}{a character vector containing the names of the
vectors that represent the data}

\item{\code{nobs}}{integer value indicating the number of observations in the 
environment}

\item{\code{classes}}{a _named_ list containing the classes of the
objects inside the environment. Note that the value should be the one
given by \code{\link{class}}.}

\item{\code{is.complete}}{a logical value indicating whether or not the poset
was added before.}
}}

\section{Note}{
 
This class is not exported, so it can't be extended as for now. 
Although it is possible to use the function \code{\link{new}} for
creation of new instances, users are strongly advised to use
the function \code{\link{new.pim.env}} in case they need to manually
create a new instance of the class \code{pim.environment}.
}

