% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetFixtures.R
\name{GetFixtures}
\alias{GetFixtures}
\title{Get Fixtures}
\usage{
GetFixtures(sportid, leagueids = NULL, since = NULL, islive = 0)
}
\arguments{
\item{sportid}{(optional) an integer giving the sport, if missing, a menu of options is presented}

\item{leagueids}{(optional) integer vector with league IDs.}

\item{since}{(optional) numeric this is used to receive incremental updates.
Use the value of `last` from previous fixtures response.}

\item{islive}{Default=FALSE, boolean if TRUE retrieves ONLY live events if FALSE retrieved all events}
}
\value{
returns a data frame with columns:
\itemize{
\item SportID
\item Last
\item League
\item LeagueID
\item EventID
\item StartTime
\item HomeTeamName
\item AwayTeamName
\item Rotation Number
\item Live Status
\item Status
\item Parlay Status
}
}
\description{
Get Fixtures
}
\examples{
\donttest{
SetCredentials("TESTAPI", "APITEST")
AcceptTermsAndConditions(accepted=TRUE)
GetFixtures(sportid = 41, leagueids = 191545)}
}

