% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetBets.R
\name{GetBetsList}
\alias{GetBetsList}
\title{Get a list of running/settled bets}
\usage{
GetBetsList(betids = NULL, betlist = c("SETTLED", "RUNNING"),
  fromDate = as.POSIXlt(Sys.Date(), tz = "UTC") - 15 * 24 * 60 * 60,
  toDate = as.POSIXlt(Sys.Date(), tz = "UTC") + 24 * 60 * 60)
}
\arguments{
\item{betids}{a vector of betids (overrides betlist) default = NULL}

\item{betlist}{Either 'SETTLED' or 'RUNNING' Default Behavior shows both}

\item{fromDate}{Iso8061 Date Default: 15 days prior in UTC, as.POSIXct(Sys.Date(), tz = 'UTC')-15*24*60*60}

\item{toDate}{Iso8061 Date  Default: 1 day ahead in UTC (to counter possible fencepost situations), as.POSIXct(Sys.Date(), tz = 'UTC') + 24*60*60}
}
\value{
A list of bets and associated details
}
\description{
Get a list of running/settled bets
}
\examples{
\donttest{
SetCredentials("TESTAPI","APITEST")
AcceptTermsAndConditions(accepted=TRUE)
GetBetsList()}
}
