% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_discard_steps}
\alias{pipe_discard_steps}
\title{Discard steps from the pipeline}
\usage{
pipe_discard_steps(pip, pattern, recursive = FALSE, fixed = TRUE, ...)
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{pattern}{\code{string} containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched.}

\item{recursive}{\code{logical} if \code{TRUE} the step is removed together
with all its downstream dependencies.}

\item{fixed}{\code{logical} If \code{TRUE}, \code{pattern} is a string to
be matched as is. Overrides all conflicting arguments.}

\item{...}{further arguments passed to \code{\link[=grep]{grep()}}.}
}
\value{
the \code{Pipeline} object invisibly
}
\description{
Discard all steps that match a given \code{pattern}.
}
\examples{
p <- pipe_new("pipe", data = 1:2)
pipe_add(p, "add1", \(x = ~data) x + 1)
pipe_add(p, "add2", \(x = ~add1) x + 2)
pipe_add(p, "mult3", \(x = ~add1) x * 3)
pipe_add(p, "mult4", \(x = ~add2) x * 4)
p

pipe_discard_steps(p, "mult")
p

# Re-add steps
pipe_add(p, "mult3", \(x = ~add1) x * 3)
pipe_add(p, "mult4", \(x = ~add2) x * 4)
p

# Discarding 'add1' does not work ...
try(pipe_discard_steps(p, "add1"))

# ... unless we enforce to remove its downstream dependencies as well
pipe_discard_steps(p, "add1", recursive = TRUE)
p

# Trying to discard non-existent steps is just ignored
pipe_discard_steps(p, "non-existent")
}
