% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_get_step}
\alias{pipe_get_step}
\alias{pipe_get_step_names}
\alias{pipe_get_step_number}
\alias{pipe_has_step}
\title{Get step information}
\usage{
pipe_get_step(pip, step)

pipe_get_step_names(pip)

pipe_get_step_number(pip, step)

pipe_has_step(pip, step)
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{step}{\code{string} name of step}
}
\value{
\itemize{
\item \code{pipe_get_step}: \code{data.table} row containing the step
\item \code{pipe_get_step_names}: \code{character} vector of step names
\item \code{pipe_get_step_number}: the step number in the pipeline
\item \code{pipe_get_step_number}: whether step exists
}
}
\description{
Get step information
}
\examples{
p <- pipe_new("pipe", data = 1:2)
pipe_add(p, "add1", \(data = ~data, x = 1) x + data)
pipe_add(p, "add2", \(x = 1, y = 2, z = ~add1) x + y + z)
pipe_run(p)

# pipe_get_step_names
pipe_get_step_names(p)

# get_step_number
pipe_get_step_number(p, "add1")
pipe_get_step_number(p, "add2")

# pipe_has_step
pipe_has_step(p, "add1")
pipe_has_step(p, "foo")

# pipe_get_step
add1 <- pipe_get_step(p, "add1")
add1

add1[["params"]]

add1[["fun"]]

try(p$get_step("foo")) # error: step 'foo' does not exist
}
