% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m278soildata.R
\docType{data}
\name{m278soildata}
\alias{m278soildata}
\title{Minenergo-278. Thermal conductivity of subsoil surrounding pipe}
\format{
A data frame with 15 rows and 3 variables:
\describe{
  \item{subsoil}{Geological name of subsoil. Type: \code{\link{assert_character}}.}
  \item{state}{The degree of water penetration to the subsoil. Type: \code{\link{assert_character}}.}
  \item{lambda}{Value of thermal conductivity of subsoil regarding water penetration, [\emph{W/m/°C}].
  Type: \code{\link{assert_double}}.
  }
 }
}
\source{
\url{https://docs.cntd.ru/document/1200035568}
}
\usage{
m278soildata
}
\description{
Data represent normative values of thermal conductivity of subsoils
which can surround pipes according to Table 5.3 of Appendix 5.3 in
\href{https://docs.cntd.ru/document/1200035568}{Minenergo Method 278}.
}
\seealso{
Other Minenergo: 
\code{\link{m278hlair}()},
\code{\link{m278hlcha}()},
\code{\link{m278hlund}()},
\code{\link{m278insdata}},
\code{\link{m278inshcm}()},
\code{\link{m325beta}()},
\code{\link{m325nhl}()},
\code{\link{m325nhldata}},
\code{\link{m325testbench}}
}
\concept{Minenergo}
\keyword{datasets}
