% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_twinning_params.R
\name{create_twinning_params}
\alias{create_twinning_params}
\title{Create the parameters for the twinning simulation}
\usage{
create_twinning_params(
  rng_seed_twin_tree = 0,
  sim_twin_tree_fun = get_sim_bd_twin_tree_fun(),
  rng_seed_twin_alignment = 0,
  sim_twal_fun = get_sim_twal_with_std_nsm_fun(),
  twin_tree_filename = to_twin_filename(get_temp_tree_filename()),
  twin_alignment_filename = to_twin_filename(get_temp_fasta_filename()),
  twin_evidence_filename = NA
)
}
\arguments{
\item{rng_seed_twin_tree}{the random number generator seed as used in the
simulation of a twin tree}

\item{sim_twin_tree_fun}{function to simulate a twin tree with.
This function must have one argument called \code{phylogeny}
of type \link[ape]{phylo} and have a return type of type \link[ape]{phylo}
as well.

Some standard functions:\cr
\itemize{
  \item Use \link{create_sim_yule_twin_tree_fun} to use a
    Yule (aka Pure Birth) process
  \item Use \link{create_copy_twtr_from_true_fun} to for a function
    that copies the true tree
  \item Use \link{get_sim_bd_twin_tree_fun} to use a
    Birth-Death process
}}

\item{rng_seed_twin_alignment}{the random number generator seed
as used in the simulation of a twin alignment}

\item{sim_twal_fun}{function to simulate a
twin alignment with.
This function must have two arguments called \code{twin_phylogeny} (which
will hold the twin phylogeny) and \code{true_alignment} (which will
hold the alignment simulated from the true phylogeny). The
return type must be \link[ape]{DNAbin}.

Use \link{check_sim_twal_fun} to verify if the function
has the right signature and output.

Some standard functions:\cr
\itemize{
  \item Use \link{get_copy_tral_fun}
    to get a function
    (\link{copy_true_alignment})
    that copies a true to alignment to create a twin alignment
  \item Use \link{get_sim_twal_with_std_nsm_fun}
    to get a function
    (\link{sim_twal_with_std_nsm})
    that simulates a twin alignment using a standard site model
  \item Use \link{get_sim_twal_same_n_muts_fun}
    to get a function
    (\link{sim_twal_with_same_n_mutation})
    that simulates -using a standard model- a twin alignment with as much
    mutations compared to the root sequence as the true alignment has
  \item Use \link{sim_twal_with_lns_nsm}
    that simulates a twin alignment using a linked node substitution
    model
  \item Use \link{sim_twal_with_uns_nsm}
    that simulates a twin alignment using an unlinked node substitution
    model
}}

\item{twin_tree_filename}{name of the (\code{.newick}) file the twin
tree will be saved to}

\item{twin_alignment_filename}{name of the FASTA file the twin
alignment will be saved to}

\item{twin_evidence_filename}{filename to store the estimated
evidences (aka marginal likelihoods) of the twin tree}
}
\value{
a twinning parameter set
}
\description{
The site model and clock models will be used and
their combination will be called the generative model
of the twinning.
}
\examples{
if (beautier::is_on_ci()) {

  twinning_params <- create_twinning_params()

  check_twinning_params(twinning_params)

  pir_params <- create_test_pir_params(
    twinning_params = twinning_params
  )
  check_pir_params(pir_params)

  if (beautier::is_on_ci() &&
    rappdirs::app_dir()$os == "unix" &&
    is_beast2_installed()) {
    pir_out <- pir_run(
      phylogeny = ape::read.tree(text = "((A:1, B:1):1, C:2);"),
      pir_params = pir_params
    )
  }

}
}
\author{
Richèl J.C. Bilderbeek, Giovanni Laudanno
}
