% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_cand_experiment.R
\name{create_cand_experiment}
\alias{create_cand_experiment}
\title{Create a valid testing \link{pirouette} candidate experiment.}
\usage{
create_cand_experiment(
  inference_conditions = create_inference_conditions(model_type = "candidate", run_if =
    "best_candidate", do_measure_evidence = TRUE),
  inference_model = beautier::create_inference_model(mcmc =
    beautier::create_mcmc(store_every = 1000)),
  beast2_options = beastier::create_beast2_options(),
  est_evidence_mcmc = beautier::create_ns_mcmc(store_every = 1000, epsilon = 1e-12)
)
}
\arguments{
\item{inference_conditions}{conditions under which the inference model
is used in the inference}

\item{inference_model}{an inference model, which is a combination
of site model, clock model, tree prior and BEAST2 input and
input filenames.}

\item{beast2_options}{BEAST2 options,
as can be created by \link[beastier]{create_beast2_options}}

\item{est_evidence_mcmc}{MCMC used in the estimation of
the evidence (aka marginal likelihood).
The MCMC must be a Nested Sampling MCMC,
as can be created by \link[beautier]{create_ns_mcmc}.}
}
\value{
a \link{pirouette} experiment.
}
\description{
Create a valid testing \link{pirouette} candidate experiment.
}
\examples{
if (beautier::is_on_ci()) {

  # Create a candidate experiment
  if (rappdirs::app_dir()$os != "win") {
    # it does not work on Windows
    experiment <- create_cand_experiment()
    check_experiment(experiment)
  }

  # Create a generative experiment
  experiment <- create_gen_experiment()
  check_experiment(experiment)

  # Use the experiment to create the full pirouette parameter set
  pir_params <- create_pir_params(
    alignment_params = create_alignment_params(),
    experiments = list(experiment)
  )

  if (rappdirs::app_dir()$os != "win" &&
    beautier::is_on_ci() && is_beast2_installed()
  ) {
    pir_out <- pir_run(
      phylogeny = ape::read.tree(text = "((A:2, B:2):1, C:3);"),
      pir_params = pir_params
    )
    pir_plot(pir_out)
  }

}
}
\author{
Richèl J.C. Bilderbeek
}
