% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_test_pir_params_setup.R
\name{create_test_pir_params_setup}
\alias{create_test_pir_params_setup}
\title{Create a \code{pir_params} that follows a specific setup}
\usage{
create_test_pir_params_setup(has_candidate = FALSE, has_twinning = FALSE)
}
\arguments{
\item{has_candidate}{TRUE to have a candidate experiment}

\item{has_twinning}{TRUE to use twinning}
}
\value{
a `pir_params` (see \link{create_pir_params})
}
\description{
Create a \code{pir_params} that follows a specific setup
}
\examples{
if (beautier::is_on_ci()) {

  # Minimal use
  check_pir_params(create_test_pir_params_setup())

  # Generative experiment only, without twinning
  create_test_pir_params_setup(
    has_candidate = FALSE,
    has_twinning = FALSE
  )

  # Generative and candidate experiment, without twinning
  if (rappdirs::app_dir()$os != "win") {
    create_test_pir_params_setup(
      has_candidate = TRUE,
      has_twinning = FALSE
    )
  }

  # Generative experiment only, with twinning
  create_test_pir_params_setup(
    has_candidate = FALSE,
    has_twinning = TRUE
  )

  # Generative and candidate experiment, with twinning
  if (rappdirs::app_dir()$os != "win") {
    create_test_pir_params_setup(
      has_candidate = TRUE,
      has_twinning = TRUE
    )
  }
}
}
