% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_all_experiments.R
\name{create_all_experiments}
\alias{create_all_experiments}
\title{Create all \link{pirouette} experiments.}
\usage{
create_all_experiments(
  site_models = beautier::create_site_models(),
  clock_models = beautier::create_clock_models(),
  tree_priors = beautier::create_tree_priors(),
  mcmc = beautier::create_mcmc(store_every = 1000),
  exclude_model = NA
)
}
\arguments{
\item{site_models}{a list of one or more site models,
as created by \link[beautier]{create_site_model}}

\item{clock_models}{a list of one or more clock models,
as created by \link[beautier]{create_clock_model}}

\item{tree_priors}{a list of one or more tree priors,
as created by \link[beautier]{create_tree_prior}}

\item{mcmc}{MCMC options, as created by \link[beautier]{create_mcmc}}

\item{exclude_model}{an inference model that has to be excluded, as can be
created by \link[beautier]{create_inference_model}}
}
\value{
all \link{pirouette} experiments.
}
\description{
These experiments are used in the \link{create_pir_params} function
}
\examples{

if (rappdirs::app_dir()$os != "win" && beautier::is_on_github_actions()) {
   # it does not work on Windows
   experiments <- create_all_experiments()
   check_experiments(experiments)

   pir_params <- create_pir_params(
     alignment_params = create_test_alignment_params(),
     experiments = experiments,
     evidence_filename = get_temp_evidence_filename()
   )
}

}
\seealso{
\itemize{
  \item Use \link{create_all_experiments} to create experiments with
    all combinations of tree model, clock model and tree priors
  \item Use \link{create_all_bd_experiments} to create experiments
    with all combinations of tree model, clock model and tree priors,
    except for only using birth-death tree priors
  \item Use \link{create_all_coal_experiments} to create all experiments
    with all combinations of tree model, clock model and tree priors,
    except for only coalescent tree priors
}
}
\author{
Richèl J.C. Bilderbeek, Giovanni Laudanno
}
