% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickPivot.R
\name{qlpvt}
\alias{qlpvt}
\title{Quickly get a Latex representation of a basic pivot table.}
\usage{
qlpvt(dataFrame, rows = NULL, columns = NULL, calculations = NULL, ...)
}
\arguments{
\item{dataFrame}{The data frame containing the data to be summarised in the
pivot table.}

\item{rows}{A character vector of variable names to be plotted on the rows of
the pivot table, or "=" to specify the position of the calculations.}

\item{columns}{A character vector of variable names to be plotted on the
columns of the pivot table, or "=" to specify the position of the
calculations.}

\item{calculations}{One or more summary calculations to use to calculate the
values of the cells in the pivot table.}

\item{...}{Additional arguments, currently format, formats, totals,
argumentCheckMode, compatibility, caption and/or label.  See the Latex
output vignette for a description of caption and label.}
}
\value{
Latex.
}
\description{
The \code{qlpvt} function returns the Latex for a basic pivot table with
one line of R.
}
\examples{
qlpvt(bhmtrains, "TOC", "TrainCategory", "n()")
qlpvt(bhmtrains, "TOC", "TrainCategory", "n()",
      caption="my caption", label="mylabel")
}
