% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_label.R
\name{sprinkle_label}
\alias{sprinkle_label}
\alias{sprinkle_label.default}
\alias{sprinkle_label.dust_list}
\title{Change the Border Collapse Property in a Dust Table}
\source{
\url{https://en.wikibooks.org/wiki/LaTeX/Labels_and_Cross-referencing}

\url{https://bookdown.org/yihui/bookdown/tables.html}
}
\usage{
sprinkle_label(x, label = NULL, ...)

\method{sprinkle_label}{default}(x, label = NULL, ...)

\method{sprinkle_label}{dust_list}(x, label = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{label}{\code{character(1)} or \code{NULL} for no label.}

\item{...}{Additional arguments to pass to other methods. Currently ignored.}
}
\description{
The \code{label} property is used to make references to a 
  table.  Labels may be used in LaTeX documents, or in both LaTeX and 
  HTML documents when using \code{bookdown}.
}
\details{
For details about using labels in LaTeX documents, see 
\url{https://en.wikibooks.org/wiki/LaTeX/Labels_and_Cross-referencing}.

For details about using labels in \code{bookdown} documents, see
\url{https://bookdown.org/yihui/bookdown/tables.html}
}
\section{Functional Requirements}{

\enumerate{
 \item Change the \code{label} attribute of the \code{dust} object.
 \item Cast an error if \code{x} is not a \code{dust} object.
 \item Cast an error if \code{label} is not a \code{character(1)}.
}
}
\author{
Benjamin Nutter
}
\seealso{
\code{\link{dust}}, \code{\link{sprinkle}}
}

