% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-home.R
\name{build_home}
\alias{build_home}
\title{Build home section}
\usage{
build_home(pkg = ".", override = list(), preview = NA,
  quiet = TRUE)
}
\arguments{
\item{pkg}{Path to package.}

\item{override}{An optional named list used to temporarily override
values in \code{_pkgdown.yml}}

\item{preview}{If \code{TRUE}, or \code{is.na(preview) && interactive()}, will preview
freshly generated section in browser.}

\item{quiet}{Set to \code{FALSE} to display output of knitr and
pandoc. This is useful when debugging.}
}
\description{
This function is responsible for building \code{.md} (or \code{.Rmd}) files typically
found in the root directory of the package. It will generate the home page
from  \code{index.Rmd} or \code{README.Rmd}, then \code{index.md} or \code{README.md}. If none of
these are found, it falls back to the description field in \code{DESCRIPTION}. It
also builds any files found in \code{.github/}.
}
\section{Images and figures}{

If you want to include images in your \code{README.md}, they must be stored in
somewhere in the package so that they can be displayed on the CRAN website.
The best place to put them is \code{man/figures}. If you are generating figures
with R Markdown, make sure you set up \code{fig.path} as followed:

\preformatted{
```\{r, include = FALSE\}
knitr::opts_chunk$set(
  fig.path = "man/figures/"
)
```
}
}

\section{Package logo}{

If you have a package logo, you can include it at the top of your README in a
level-one heading:\preformatted{# pkgdown <img src="man/figures/logo.png" align="right" />
}

\code{\link[=init_site]{init_site()}} will also automatically create a favicon set from your package
logo.
}

\section{YAML config - home}{

To tweak the home page, you need a section called \code{home}.

The sidebar links are automatically generated by inspecting the \code{URL} and
\code{BugReports} fields of the \code{DESCRIPTION}. You can add additional links with a
subsection called \code{links}, which should contain a list of \code{text} + \code{href}
elements:\preformatted{home:
  links:
  - text: Link text
    href: http://website.com
}

You can remove the first heading with:\preformatted{home:
  strip_header: true
}
}

\section{YAML config - authors}{

The "developers" list is populated by the maintainer ("cre"), authors
("aut"), and funder ("fnd") from the \code{DESCRIPTION}. You can modify their
display on the home page by adding a subsection for \code{authors}. The author
name should match the value in \code{DESCRIPTION}:\preformatted{authors:
  name:
    href: "http://name-website.com"
    html: "<img src='name-picture.png' height=24>"
}
}

\section{ORCID}{

ORCID identification numbers are added to author info if they
are defined in the \code{DESCRIPTION}:\preformatted{person("Jay", "Hesselberth", role = "aut",
  comment = c(ORCID = "0000-0002-6299-179X")
),
}
}

\section{Badges}{

Status badges are displayed in the sidebar under the section "Dev status".
This section is automatically populated if the first paragraph of the
homepage consists solely of status badges as linked images.
}

