% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{image_binary}
\alias{image_binary}
\title{Creates a binary image}
\usage{
image_binary(
  image,
  index = NULL,
  my_index = NULL,
  resize = TRUE,
  fill_hull = FALSE,
  re = NULL,
  nir = NULL,
  invert = FALSE,
  show_image = TRUE,
  nrow = NULL,
  ncol = NULL,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE
)
}
\arguments{
\item{image}{An image object.}

\item{index}{A character value (or a vector of characters) specifying the
target mode for conversion to binary image. One of the following:  \code{"R"},
\code{"G"}, \code{"B"} \code{"GR"}, \code{"NR"}, \code{"NG"}, \code{"NB"}, \code{"BI"}, \code{"BIM"}, \code{"SCI"},
\code{"GLI"}, \code{"HI"}, \code{"NGRDI"}, \code{"SI"}, \code{"VARI"}, \code{"HUE"}, \code{"HUE2"}, \code{"BGI"},
\code{"BGI"}. See \code{\link[=image_index]{image_index()}} for more details.}

\item{my_index}{User can calculate a different index using the bands names,
e.g. \code{my_index = "R+B/G"}.}

\item{resize}{Resize the image before processing? Defaults to \code{TRUE}. Resizes
the image to 30\% of the original size to speed up image processing.}

\item{fill_hull}{Fill holes in the objects? Defaults to \code{FALSE}.}

\item{re}{Respective position of the red-edge band at the original image
file.}

\item{nir}{Respective position of the near-infrared band at the original
image file.}

\item{invert}{Inverts the binary image, if desired.}

\item{show_image}{Show image after processing?}

\item{nrow, ncol}{The number of rows or columns in the plot grid. Defaults to
\code{NULL}, i.e., a square grid is produced.}

\item{parallel}{Processes the images asynchronously (in parallel) in separate
R sessions running in the background on the same machine. It may speed up
the processing time when \code{image} is a list. The number of sections is set
up to 90\% of available cores.}

\item{workers}{A positive numeric scalar or a function specifying the maximum
number of parallel processes that can be active at the same time.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}
}
\value{
A list containing binary images. The length will depend on the number
of indexes used.
}
\description{
Reduce a color, color near-infrared, or grayscale images to a binary image
using a given color channel (red, green blue) or even color indexes. The
Otsu's thresholding method (Otsu, 1979) is used to automatically perform
clustering-based image thresholding.
}
\examples{
library(pliman)
img <- image_import(image_pliman("soybean_touch.jpg"))
image_binary(img, index = c("R, NR"), nrow = 1)
}
\references{
Nobuyuki Otsu, "A threshold selection method from gray-level
histograms". IEEE Trans. Sys., Man., Cyber. 9 (1): 62-66. 1979.
\doi{10.1109/TSMC.1979.4310076}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
