% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{utils_transform}
\alias{utils_transform}
\alias{image_dimension}
\alias{image_rotate}
\alias{image_horizontal}
\alias{image_vertical}
\alias{image_hreflect}
\alias{image_vreflect}
\alias{image_resize}
\title{Spatial transformations}
\usage{
image_dimension(image, parallel = FALSE, workers = NULL, verbose = TRUE)

image_rotate(
  image,
  angle,
  bg_col = "white",
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE
)

image_horizontal(image, parallel = FALSE, workers = NULL, verbose = TRUE)

image_vertical(image, parallel = FALSE, workers = NULL, verbose = TRUE)

image_hreflect(image, parallel = FALSE, workers = NULL, verbose = TRUE)

image_vreflect(image, parallel = FALSE, workers = NULL, verbose = TRUE)

image_resize(
  image,
  rel_size = 100,
  width,
  height,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE
)
}
\arguments{
\item{image}{An image or a list of images of class \code{Image}.}

\item{parallel}{Processes the images asynchronously (in parallel) in separate
R sessions running in the background on the same machine. It may speed up
the processing time when \code{image} is a list. The number of sections is set
up to 90\% of available cores.}

\item{workers}{A positive numeric scalar or a function specifying the maximum
number of parallel processes that can be active at the same time.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}

\item{angle}{The rotation angle in degrees.}

\item{bg_col}{Color used to fill the background pixels, defaults to \code{"white"}.}

\item{rel_size}{The relative size of the resized image. Defaults to 100. For
example, setting \code{rel_size = 50} to an image of width \verb{1280 x 720}, the new
image will have a size of \verb{640 x 360}.}

\item{width, height}{Width and height of the resized image. These arguments
can be missing. In this case, the image is resized according to the
relative size informed in \code{rel_size}.}
}
\value{
A modified version of \code{image} depending on the function used.
}
\description{
Performs image rotation and reflection
\itemize{
\item \code{image_dimension()} Gives the dimension (width and height) of an image.
\item \code{image_rotate()} rotates the image clockwise by the given angle.
\item \code{image_horizontal()} converts (if needed) an image to a horizontal image.
\item \code{image_vertical()} converts (if needed) an image to a vertical image.
\item \code{image_hreflect()} performs horizontal reflection of the \code{image}.
\item \code{image_vreflect()} performs vertical reflection of the \code{image}.
\item \code{image_resize()} resize the \code{image}.
}
}
\examples{
library(pliman)
img <- image_import(image_pliman("sev_leaf.jpg"))
image_show(img)
img <- image_resize(img, 50)
img1 <- image_rotate(img, 45)
img2 <- image_hreflect(img)
img3 <- image_vreflect(img)
img4 <- image_vertical(img)
image_combine(img1, img2, img3, img4)
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
