% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_objects.R
\name{utils_objects}
\alias{utils_objects}
\alias{object_coord}
\alias{object_contour}
\alias{object_isolate}
\alias{object_id}
\title{Utilities for working with image objects}
\usage{
object_coord(
  image,
  id = NULL,
  index = "NB",
  watershed = TRUE,
  invert = FALSE,
  fill_hull = FALSE,
  edge = 2,
  extension = NULL,
  tolerance = NULL,
  object_size = "medium",
  parallel = FALSE,
  workers = NULL,
  show_image = TRUE
)

object_contour(
  image,
  index = "NB",
  invert = FALSE,
  fill_hull = FALSE,
  watershed = TRUE,
  extension = NULL,
  tolerance = NULL,
  object_size = "medium",
  parallel = FALSE,
  workers = NULL,
  show_image = TRUE
)

object_isolate(image, id = NULL, parallel = FALSE, workers = NULL, ...)

object_id(image, parallel = FALSE, workers = NULL, ...)
}
\arguments{
\item{image}{An image of class \code{Image} or a list of \code{Image} objects.}

\item{id}{\itemize{
\item For \code{object_coord()}, a vector (or scalar) of object \code{id} to compute the
bounding rectangle. Object ids can be obtained with \code{\link[=object_id]{object_id()}}. Set \code{id = "all"} to compute the coordinates for all objects in the image. If \code{id = NULL} (default) a bounding rectangle is drawn including all the objects.
\item For \code{object_isolate()}, a scalar that identifies the object to be extracted.
}}

\item{index}{The index to produce a binary image used to compute bounding
rectangle coordinates. See \code{\link[=image_binary]{image_binary()}} for more details.}

\item{watershed}{If \code{TRUE} (default) performs watershed-based object
detection. This will detect objects even when they are touching one other.
If \code{FALSE}, all pixels for each connected set of foreground pixels are set
to a unique object. This is faster but is not able to segment touching
objects.}

\item{invert}{Inverts the binary image, if desired. Defaults to \code{FALSE}.}

\item{fill_hull}{Fill holes in the objects? Defaults to \code{FALSE}.}

\item{edge}{The number of pixels in the edge of the bounding rectangle.
Defaults to \code{2}.}

\item{extension, tolerance, object_size}{Controls the watershed segmentation of
objects in the image. See \code{\link[=analyze_objects]{analyze_objects()}} for more details.}

\item{parallel}{Processes the images asynchronously (in parallel) in separate
R sessions running in the background on the same machine. It may speed up
the processing time when \code{image} is a list. The number of sections is set
up to 50\% of available cores.}

\item{workers}{A positive numeric scalar or a function specifying the maximum
number of parallel processes that can be active at the same time.}

\item{show_image}{Shows the image with bounding rectangles? Defaults to
\code{TRUE}.}

\item{...}{\itemize{
\item For \code{object_isolate()}, further arguments passed on to \code{\link[=object_coord]{object_coord()}}.
\item For \code{object_id()}, further arguments passed on to \code{\link[=analyze_objects]{analyze_objects()}}.
}}
}
\value{
\itemize{
\item \code{object_id()} An image of class \code{"Image"} containing the object's
identification.
\item \code{object_coord()} A list with the coordinates for the bounding rectangles.
If \code{id = "all"} or a numeric vector, a list with a vector of coordinates is
returned.
\item \code{object_isolate()} An image of class \code{"Image"} containing the isolated
object.
}
}
\description{
\itemize{
\item \code{object_id()} get the object identification in an image.
\item \code{object_coord()} get the object coordinates and (optionally) draw a
bounding rectangle around multiple objects in an image.
\item \code{object_contour()} returns the coordinates (\code{x} and \code{y}) for the contours
of each object in the image.
\item \code{object_isolate()} isolates an object from an image.
}
}
\examples{
\donttest{
library(pliman)
img <- image_pliman("la_leaves.jpg")
# Get the object's (leaves) identification
object_id(img)

# Get the coordinates and draw a bounding rectangle around leaves 1 and 3
object_coord(img, id = c(1, 3))

# Isolate leaf 3
isolated <- object_isolate(img, id = 3)
plot(isolated)

}
}
