% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_pick.R
\name{utils_pick}
\alias{utils_pick}
\alias{pick_count}
\alias{pick_rgb}
\alias{pick_palette}
\title{Picking up points in an image}
\usage{
pick_count(
  image,
  n = Inf,
  col = "red",
  size = 0.8,
  plot = TRUE,
  verbose = TRUE
)

pick_rgb(image, n = Inf, col = "red", size = 0.8, plot = TRUE, verbose = TRUE)

pick_palette(
  image,
  n = Inf,
  r = 3,
  shape = "box",
  random = TRUE,
  width = 100,
  height = 100,
  col = "red",
  size = 0.8,
  plot = TRUE,
  palette = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{image}{An \code{Image} object.}

\item{n}{The number of points of the \verb{pick_*} function. Defaults to \code{Inf}.
This means that picking will run until the user press Esc.}

\item{col, size}{The color and size for the marker point.}

\item{plot}{Call a new \code{plot(image)} before processing? Defaults to \code{TRUE}.}

\item{verbose}{If \code{TRUE} (default) shows a counter in the console.}

\item{r}{The radius of neighborhood pixels. Defaults to \code{3}.}

\item{shape}{A character vector indicating the shape of the brush around the
selected pixel. It  can be \code{"box"}, \code{"disc"}, \code{"diamond"}, \code{"Gaussian"} or
\code{"line"}. Defaults to \code{"box"}. In this case, if \code{'r = 1'}, all the 8
surrounding pixels are sampled. Setting to \code{"disc"} and increasing the
radius (\code{r}) will select surrounding pixels towards the format of a sphere
around the selected pixel.}

\item{random}{Randomize the selected pixels? Defaults to \code{TRUE}.}

\item{width, height}{The width and height of the generated palette. Defaults
to \code{100} for both, i.e., a square image of 100 x 100.}

\item{palette}{Plot the generated palette? Defaults to \code{TRUE}.}
}
\value{
\itemize{
\item \code{pick_count()} returns \code{data.frame} with the \code{x} and \code{y} coordinates of the
selected point(x).
\item \code{pick_rgb()} returns a \code{data.frame} with the R, G, and B values of the
selected point(s).
\item \code{pick_palette()} returns an object of class \code{Image}.
}
}
\description{
\itemize{
\item \code{pick_count()} opens an interactive section where the user will be able to
click in the image to count objects (points) manually. In each mouse click, a
point is drawn and an upward counter is shown in the console. After \code{n}
counts or after the user press Esc, the interactive process is terminated and
a data.frame with the \code{x} and \code{y} coordinates for each point is returned.
\item \code{pick_palette()}  creates an image palette by picking up color point(s)
from the image.
\item \code{pick_rgb()} Picks up the RGB values from selected point(s) in the image.
}
}
\examples{
if(interactive()){
library(pliman)
img <- image_pliman("soybean_touch.jpg")

# start a counting process
pick_count(img)

# get rgb from point(s)
pick_rgb(img)

# create a palette from point(s)
pick_palette(img)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
