% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individualQC.R
\name{overviewPerIndividualQC}
\alias{overviewPerIndividualQC}
\title{Overview of per sample QC}
\usage{
overviewPerIndividualQC(results_perIndividualQC, interactive = FALSE)
}
\arguments{
\item{results_perIndividualQC}{[list] Output of \code{\link{perIndividualQC}}
i.e. named [list]
with i) sample_missingness containing a [vector] with sample IIDs failing
the selected missingness threshold imissTh, ii) highIBD containing
a [vector] with sample IIDs failing the selected relatedness threshold
highIBDTh, iii) outlying_heterozygosity containing a [vector] with sample
IIDs failing selected the heterozygosity threshold hetTh, iv) mismatched_sex
containing a [vector] with the sample IIDs failing the sexcheck based on
SNPSEX and selected femaleTh/maleTh, v) ancestry containing a vector with
sample IIDs failing the ancestry check based on the selected europeanTh and
vi) p_sampleQC, a ggplot2-object 'containing' a sub-paneled plot with the
QC-plots of \code{\link{check_sex}},
\code{\link{check_het_and_miss}},
\code{\link{check_relatedness}} and \code{\link{check_ancestry}}.}

\item{interactive}{[logical] Should plots be shown interactively? When
choosing this option, make sure you have X-forwarding/graphical interface
available for interactive plotting. Alternatively, set interactive=FALSE and
save the returned plot object (p_overview) via ggplot2::ggsave(p=p_overview,
other_arguments) or pdf(outfile) print(p_overview) dev.off().}
}
\value{
Named [list] with i) nr_fail_samples: total number of samples
[integer] failing perIndividualQC, ii) fail_QC containing a [data.frame] with
samples that failed QC steps (excluding ancestry): samples IIDs in rows,
columns are all QC steps applied by perIndividualQC (max=4), with entries=0 if
passing the QC and entries=1 if failing that particular QC and iii)
fail_QC_and_ancestry containing a [data.frame] with samples that failed
ancestry and QC checks: samples IIDs in rows, columns are QC_fail and
Ancestry_fail, with entries=0 if passing and entries=1 if failing that check.
}
\description{
\code{overviewPerIndividualQC} depicts results of
\code{\link{perIndividualQC}} as intersection plots
(via \code{\link[UpSetR]{upset}}) and returns dataframes indicating
which QC checks individuals failed or passed.
}
\examples{
indir <- system.file("extdata", package="plinkQC")
qcdir <- tempdir()
name <- "data"
\dontrun{
fail_individuals <- perIndividualQC(qcdir=qcdir, indir=indir, name=name,
refSamplesFile=paste(qcdir, "/HapMap_ID2Pop.txt",sep=""),
refColorsFile=paste(qcdir, "/HapMap_PopColors.txt", sep=""),
prefixMergedDataset="data.HapMapIII", interactive=FALSE, verbose=FALSE,
do.run_check_het_and_miss=FALSE, do.run_check_relatedness=FALSE,
do.run_check_sex=FALSE, do.run_check_ancestry=FALSE)

overview <- overviewPerIndividualQC(fail_individuals)
}
}
