% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.matrix.R
\name{plot.matrix}
\alias{plot.matrix}
\alias{plot}
\title{plot.matrix}
\usage{
\method{plot}{matrix}(x, y = NULL, digits = NA, col = NULL,
  breaks = NULL, key = list(cex.axis = 1), na.col = "white", ...)
}
\arguments{
\item{x}{matrix}

\item{y}{unused}

\item{digits}{number of digits for numeric data or length of string for non-numeric data}

\item{col}{a vector of colors}

\item{breaks}{breaks for numeric values or values for \code{col}}

\item{key}{list of parameters used for \code{\link[graphics]{axis}}. If set to \code{NULL} then no information will be plotted.}

\item{na.col}{color for missing value (default: white)}

\item{...}{further parameter given to the \code{\link[graphics]{plot}} command}
}
\value{
a plot
}
\description{
Visualizes a matrix with a heatmap and distinguishes between numeric and non-numeric matrices. 
You may need to modify \code{mar} with the \code{\link[graphics]{par}} command from its default \code{c(5.1,4.1,4.1,2.1)}.
}
\details{
In case of a numeric matrix it should hold \code{length(breaks)==length(col)+1}. If not or not given at all then the 
\code{breaks} is recalculated as an equidistant grid between \code{min(breaks)} and \code{max(breaks)}.
If \code{col} is not given then \code{heat.color(10)} is used.

In case of a non-numeric matrix it should hold \code{length(breaks)==length(col)}. If  not given at allthen the 
\code{breaks} is determined by the unique elements of the matrix. If \code{col} is not given then \code{heat.color} is used
with the number of unique elements in \code{x}.
}
\examples{
par(mar=c(5.1, 4.1, 4.1, 4.1))
# numeric matrix
x <- matrix(runif(50), nrow=10)
plot(x)
plot(x, key=NULL)
plot(x, key=list(cex.axis=0.5, tick=FALSE))
plot(x, digits=3)
plot(x, breaks=c(0,1), digits=3, cex=0.6)
# logical matrix
m <- matrix(runif(50)<0.5, nrow=10)
plot(m)
plot(m, key=NULL, digits=1)
# character matrix
s <- matrix(sample(letters[1:10], 50, replace=TRUE), nrow=10)
plot(s)
plot(s, digits=10)
plot(s, digits=10, col=heat.colors(5), breaks=letters[1:5])

}
