#' 25 Personality items representing 5 factors
#' 
#' 25 personality self report items taken from the International Personality Item Pool (ipip.ori.org) were included as 
#' part of the Synthetic Aperture Personality Assessment (SAPA) web based personality assessment project.  
#' In contrast to the original data \code{bfi} from the library \code{psych} (version 1.8.12) 
#' it contains only the 25 personality self report items and the 2436 complete observations.
#' 
#' @docType data
#' 
#' @usage data(bfi.2)
#' 
#' @format
#' A data frame with 2436 observations on the following 25 variables (the q numbers are the SAPA item numbers).
#'   \describe{
#'     \item{\code{A1}}{Am indifferent to the feelings of others. (q_146)}
#'     \item{\code{A2}}{Inquire about others' well-being. (q_1162)}
#'     \item{\code{A3}}{Know how to comfort others. (q_1206) }
#'     \item{\code{A4}}{Love children. (q_1364)}
#'     \item{\code{A5}}{Make people feel at ease. (q_1419)}
#'     \item{\code{C1}}{Am exacting in my work. (q_124)}
#'     \item{\code{C2}}{Continue until everything is perfect. (q_530)}
#'     \item{\code{C3}}{Do things according to a plan. (q_619)}
#'     \item{\code{C4}}{Do things in a half-way manner. (q_626)}
#'     \item{\code{C5}}{Waste my time. (q_1949)}
#'     \item{\code{E1}}{Don't talk a lot. (q_712)}
#'     \item{\code{E2}}{Find it difficult to approach others. (q_901)}
#'     \item{\code{E3}}{Know how to captivate people. (q_1205)}
#'     \item{\code{E4}}{Make friends easily. (q_1410)}
#'     \item{\code{E5}}{Take charge. (q_1768)}
#'     \item{\code{N1}}{Get angry easily. (q_952)}
#'     \item{\code{N2}}{Get irritated easily. (q_974)}
#'     \item{\code{N3}}{Have frequent mood swings. (q_1099}
#'     \item{\code{N4}}{Often feel blue. (q_1479)}
#'     \item{\code{N5}}{Panic easily. (q_1505)}
#'     \item{\code{O1}}{Am full of ideas. (q_128)}
#'     \item{\code{O2}}{Avoid difficult reading material.(q_316)}
#'     \item{\code{O3}}{Carry the conversation to a higher level. (q_492)}
#'     \item{\code{O4}}{Spend time reflecting on things. (q_1738)}
#'     \item{\code{O5}}{Will not probe deeply into a subject. (q_1964)}
#' }
#'
#' The 25 items are organized by five putative factors: Agreeableness, Conscientiousness, Extraversion, Neuroticism, and Opennness.
#'   
#' The item data were collected using a 6 point response scale: 
#' \describe{
#'   \item{1}{Very Inaccurate}
#'   \item{2}{Moderately Inaccurate}
#'   \item{3}{Slightly Inaccurate}
#'   \item{4}{Slightly Accurate}
#'   \item{5}{Moderately Accurate}
#'   \item{6}{Very Accurate}
#'  }
#'  as part of the Synthetic Apeture Personality Assessment (SAPA \url{https://sapa-project.org}) project.  
#'  To see an example of the data collection technique, visit \url{https://SAPA-project.org} or 
#'  the International Cognitive Ability Resource at \url{https://icar-project.com}. The items given were sampled 
#'  from the International Personality Item Pool of Lewis Goldberg using the sampling technique of SAPA.  
#'  This is a sample data set taken from the much larger SAPA data bank.
#' 
#' @source  The items are from the ipip (Goldberg, 1999). The data are from the SAPA project 
#' (Revelle, Wilt and Rosenthal, 2010), collected Spring, 2010 ( \url{https://sapa-project.org}).
#' @references  
#'   Goldberg, L.R. (1999) A broad-bandwidth, public domain, personality inventory measuring the lower-level facets of several five-factor models. In Mervielde, I. and Deary, I. and De Fruyt, F. and Ostendorf, F. (eds) Personality psychology in Europe. 7. Tilburg University Press. Tilburg, The Netherlands.
#'
#'   Revelle, W., Wilt, J.,  and Rosenthal, A. (2010)  Individual Differences in Cognition: New Methods for examining the Personality-Cognition Link In Gruszka, A.  and Matthews, G. and Szymura, B. (Eds.) Handbook of Individual Differences in Cognition: Attention, Memory and Executive Control, Springer.
#'
#'   Revelle, W,  Condon, D.M.,  Wilt, J.,  French, J.A., Brown, A.,  and  Elleman, L.G. (2016) Web and phone based data collection using planned missing designs. In  Fielding, N.G.,  Lee, R.M. and  Blank, G. (Eds). SAGE Handbook of Online Research Methods (2nd Ed), Sage Publcations. 
#'
#' @note The bfi.2 data set and items should not be confused with the BFI (Big Five Inventory) of Oliver John and colleagues (John, O. P., Donahue, E. M., & Kentle, R. L. (1991). The Big Five Inventory--Versions 4a and 54. Berkeley, CA: University of California,Berkeley, Institute of Personality and Social Research.)
#' 
#' @examples
#' data(bfi.2)
#' library("psych")
#' fa <- fa(bfi.2, 5, rotate="varimax")
#' par(mar=c(5.1, 4.1, 4.1, 4.1)) # adapt margins
#' plot(loadings(fa), cex=0.5)
"bfi.2"

#' New York Air Quality Measurements
#' 
#' p-values of pairwise correlation test of the complete-cases of 
#' daily air quality measurements in New York, May to September 1973.
#' 
#' @docType data
#' 
#' @usage data(air.pvalue)
#' 
#' @format
#' A 4x4 matrix with p values of pairwise correlation tests (\code{\link[stats]{cor.test}}).
#'   \describe{
#'     \item{\code{Ozone}}{Ozone (ppb)}
#'     \item{\code{Solar.R}}{Solar R (lang)}
#'     \item{\code{Wind}}{Wind (mph)}
#'     \item{\code{Temp}}{Temperature (degrees F)}
#' }
#'    
#' @source  The data are derived from the \link[datasets:airquality]{New York Air Quality Measurements} data set.
#' @references Chambers, J. M., Cleveland, W. S., Kleiner, B. and Tukey, P. A. (1983) Graphical Methods for Data Analysis. Belmont, CA: Wadsworth.
#' 
#' @examples
#' data(air.pvalue)
#' plot(as.pvalue(air.pvalue))
"air.pvalue"

#' Survival of passengers on the Titanic
#' 
#' Matrix of Cramer's V computed on the variables economic status (class), sex, age and survival of the 
#' fate of passengers on the fatal maiden voyage of the ocean liner 'Titanic'.
#' 
#' @docType data
#' 
#' @usage data(Titanic.cramer)
#' 
#' @format
#' A 4x4 matrix with Cramer's V computed on
#'   \describe{
#'     \item{\code{Class}}{1st, 2nd, 3rd, Crew}
#'     \item{\code{Sex}}{Male, Female}
#'     \item{\code{Age}}{Child, Adult}
#'     \item{\code{Survived}}{No, Yes}
#' }
#'    
#' @source  The data are derived from the \link[datasets:Titanic]{Survival of passengers on the Titanic} data set.
#' 
#' @examples
#' data(Titanic.cramer)
#' plot(as.assoc(Titanic.cramer))
"Titanic.cramer"