% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-model.R
\name{read_model}
\alias{read_model}
\title{Builds up matrix of coefficients from fitted models}
\usage{
read_model(model, type, alpha)
}
\arguments{
\item{model}{see \code{\link{field3logit}}.}

\item{type}{class of the model. Currently, forced to \code{"logit"}
by \code{\link{field3logit}} when \code{\link{read_model}} is called.}

\item{alpha}{see \code{\link{field3logit}}.}
}
\value{
A named \code{list} with the following components:

\item{B}{matrix of coefficients.}
\item{model}{argument \code{type}.}
\item{ordinal}{\code{logical} variable indicating wheter the model is
ordinal or not.}
\item{P2XB}{link function.}
\item{XB2P}{inverse of the link function.}
\item{DeltaB2pc}{function that computes the points the curve of
the field should pass through (see \code{\link{DeltaB2pc}}).}
}
\description{
It reads arguments \code{model}, \code{ordinal}, \code{type} and \code{alpha} passed
by function \code{\link{field3logit}} and properly sets the matrix of
coefficient and the other needed model-specific functions.
}
\seealso{
\code{\link{plot3logit-package}}, \code{\link{field3logit}}.
}
\keyword{internal}
