% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ternary.R
\name{TernaryField}
\alias{TernaryField}
\title{Draw a field on an existing ternary plot}
\usage{
TernaryField(
  field,
  ...,
  length = 0.05,
  conf = FALSE,
  npoints = 100,
  conf.args = list()
)
}
\arguments{
\item{field}{object of class \code{field3logit} as returned by
\code{\link[=field3logit]{field3logit()}}.}

\item{...}{other arguments passed to or from other methods.}

\item{length}{length of the edges of the arrow head (in inches).}

\item{conf}{if \code{FALSE} confidence regions are not drawn, even if available;
if \code{TRUE} confidence regions are drawn only if available; if a \code{numeric}
value is passed, confidence regions at the specified confidence level
are computed (if not already available) and drawn.}

\item{npoints}{number of points of the border to be computed \strong{for each
confidence region}.}

\item{conf.args}{graphical parameters of confidence regions to be passed
to \code{\link[=TernaryPolygon]{TernaryPolygon()}}.}
}
\value{
An object of class \code{field3logit} with confidence regions included, if
computed within \code{\link[=TernaryField]{TernaryField()}}.
}
\description{
\code{\link[=TernaryField]{TernaryField()}} adds the vector field returned by \code{\link[=field3logit]{field3logit()}} to an
existing ternary plot generated by \code{\link[Ternary:TernaryPlot]{Ternary::TernaryPlot()}}.
}
\examples{
library(nnet)
data(cross_1year)

mod0 <- nnet::multinom(employment_sit ~ gender + finalgrade, data = cross_1year)
field0 <- field3logit(mod0, 'genderFemale')

TernaryPlot()
TernaryField(field0)

}
\seealso{
\code{\link[=field3logit]{field3logit()}}.
}
