% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot3logit-deprecated.R
\name{plot3logit-deprecated}
\alias{plot3logit-deprecated}
\alias{plot3logit}
\title{Computation and representation of the vector field}
\usage{
plot3logit(
  model,
  delta,
  label = "<empty>",
  p0 = NULL,
  alpha = NULL,
  ncurves = 8,
  narrows = Inf,
  edge = 0.01,
  ...
)
}
\arguments{
\item{model}{either a fitted trinomial model or a matrix of regressor
coefficients. See section \emph{Compatibility} and examples of
\code{\link{plot3logit-package}}.}

\item{delta}{the change in the values of covariates to be represented.
This could be either a \code{numeric} vector, the name of a covariate
(passed either as a \code{character} or an \code{expression}), or a mathematical
expression involving one or more than one covariates (passed either as
a \code{character} or an \code{expression}). See details and examples.}

\item{label}{label to be used for identifying the field when multiple
fields are plotted. See \code{\link[=multifield3logit]{multifield3logit()}}.}

\item{p0}{\code{list} of starting points (ternary coordinates) of the curves
of the field. If not specified, \code{field3logit} automatically compute
\code{ncurves} candidate points so that arrows are evenly distributed over
the ternary plot area. See Examples.}

\item{alpha}{\code{numeric} vector of length two where constants \eqn{\alpha^{(1)}}
and \eqn{\alpha^{(2)}} are stored (only for ordinal models), as
defined in Equation (7) of \insertCite{santi2019;textual}{plot3logit}.}

\item{ncurves}{number of curves of the field to be computed. In case
of ordinal models, this parameter is ineffective, as only one curve
can be drawn. The parameter is ineffective also in case that argument
\code{p0} is set.}

\item{narrows}{maximum number of arrows to be drawn per curve.}

\item{edge}{minimum distance between each arrow (or point) and
the edge of the ternary plot.}

\item{...}{other arguments passed to or from other methods.}
}
\value{
\code{S3} object of class \code{field3logit} structured as a named \code{list}.
}
\description{
\lifecycle{deprecated}

This function is deprecated and may be soon removed from the package.

\code{\link[=plot3logit]{plot3logit()}} method draws the ternary plot using standard graphics
methods provided by package \code{Ternary}. Use the method \code{\link[=plot]{plot()}} of
\code{field3logit} objects instead.
}
\seealso{
\code{\link[=field3logit]{field3logit()}}.
}
