% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtern.R
\name{stat_conf3logit}
\alias{stat_conf3logit}
\title{Add the confidence regions of a field to a \code{gg3logit} plot}
\usage{
stat_conf3logit(
  mapping = aes(),
  data = NULL,
  geom = "polygon",
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{list of aesthetic mappings to be used for plot. Mandatory
aesthetics should not be specified if \code{field3loglit} or \code{multifield3logit}
object is passed to \code{data}. See secion"Aesthetic mappings" of
\code{\link[=gg3logit]{gg3logit()}} for details.}

\item{data}{a \code{field3logit} or a \code{multifield3logit} object.}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
\code{\link[=stat_conf3logit]{stat_conf3logit()}} adds a field to a \code{\link{gg3logit}} plot.
}
\examples{
\dontrun{
data(cross_1year)

mod0 <- nnet::multinom(employment_sit ~ gender + finalgrade, data = cross_1year)
field0 <- field3logit(mod0, 'genderFemale', conf = 0.95)

gg3logit(field0) + stat_conf3logit()
gg3logit(field0) + stat_field3logit() + stat_conf3logit()
}

}
\seealso{
Other gg functions: 
\code{\link{autoplot.field3logit}()},
\code{\link{gg3logit}()},
\code{\link{stat_3logit}()},
\code{\link{stat_field3logit}()}
}
\concept{gg functions}
