% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_rocci.R
\docType{data}
\name{geom_rocci}
\alias{geom_rocci}
\alias{GeomRocci}
\title{Confidence regions for the ROC curve}
\format{An object of class \code{GeomRocci} (inherits from \code{Geom}, \code{ggproto}) of length 6.}
\usage{
geom_rocci(mapping = NULL, data = NULL, stat = "rocci", ci.at = NULL,
  sig.level = 0.05, na.rm = TRUE, alpha.box = 0.3, labels = TRUE,
  labelsize = 3.88, labelround = 1, position = "identity",
  show.legend = NA, inherit.aes = TRUE, ...)

GeomRocci
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{stat}{Use to override the default connection between
\code{geom_rocci} and \code{stat_rocci}.}

\item{ci.at}{Vector of values in the range of the biomarker where confidence regions will be displayed}

\item{sig.level}{Significance level for the confidence regions}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{alpha.box}{Alpha level for the confidence regions}

\item{labels}{If TRUE, adds text labels for the cutoffs where the confidence regions are displayed}

\item{labelsize}{Size of cutoff text labels}

\item{labelround}{Integer, number of significant digits to round cutoff labels}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
Display rectangular confidence regions for the empirical ROC curve.
}
\section{Aesthetics}{

\code{geom_rocci} understands the following aesthetics (required aesthetics
are in bold). \code{stat_rocci} automatically maps the estimates to the required aesthetics:
\itemize{
  \item \strong{\code{x}} The FPF estimate
  \item \strong{\code{y}} The TPF estimate
  \item \strong{\code{xmin}} Lower confidence limit for the FPF
  \item \strong{\code{xmax}} Upper confidence limit for the FPF
  \item \strong{\code{ymin}} Lower confidence limit for the TPF
  \item \strong{\code{ymax}} Upper confidence limit for the TPF
  \item \code{alpha}
  \item \code{color}
  \item \code{fill}
  \item \code{linetype}
  \item \code{size}
}
}

\examples{

D.ex <- rbinom(50, 1, .5)
rocdata <- data.frame(D = c(D.ex, D.ex), 
                   M = c(rnorm(50, mean = D.ex, sd = .4), rnorm(50, mean = D.ex, sd = 1)), 
                   Z = c(rep("A", 50), rep("B", 50)))

ggplot(rocdata, aes(m = M, d = D)) + geom_roc() + geom_rocci()
ggplot(rocdata, aes(m = M, d = D, color = Z)) + geom_roc() + geom_rocci()
ggplot(rocdata, aes(m = M, d = D, color = Z)) + geom_roc() + geom_rocci(sig.level = .01)
ggplot(rocdata, aes(m = M, d = D)) + geom_roc(n.cuts = 0) + 
geom_rocci(ci.at = quantile(rocdata$M, c(.1, .25, .5, .75, .9)))
ggplot(rocdata, aes(m = M, d = D, color = Z)) + geom_roc() + geom_rocci(linetype = 1)
}
\seealso{
See \code{\link{geom_roc}} for the empirical ROC curve, \code{\link{style_roc}} for 
  adding guidelines and labels, and \code{\link{direct_label}} for adding direct labels to the 
  curves. Also \link{export_interactive_roc} for creating interactive ROC curve plots for use in a web browser.
}
\keyword{datasets}
