% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sunshinexy.R
\name{sunshinexy}
\alias{sunshinexy}
\title{Generating Lines Which Link One Points to Many}
\usage{
sunshinexy(x = 0, y = 0, outer = data.frame(1, 1), n = 10,
  delete_n = 0, distance = FALSE, checks = TRUE)
}
\arguments{
\item{x}{the x coordinate of the middle points. 
It should be of length 1.}

\item{y}{the y coordinate of the middle points. 
It should be of length 1.}

\item{outer}{the other points. It can be a data frame, 
It must have exactly 2 columns 
and must be numeric without NA.}

\item{n}{default is 10. The number of points per line.}

\item{delete_n}{default is 0. The number of points to be deleted. 
Suppose a line has p1, p2, p3, p4, p5 points on it with 
p1 as the starting point. if delete_n is 2, then p1 and p2 
will be deleted. Note: \code{n - delete_n} 
must be larger than 1.}

\item{distance}{default is FALSE. If it is TRUE, a column 
named "distance" is added which indicates the distances from 
the middle point to other points.}

\item{checks}{default is TRUE. It indicates whether 
to check input validity. Do not turn it off unless you are sure 
that the input is OK.}
}
\value{
A data frame that has 3 columns.
The first and second columns are 
named "x" and "y", the third column is  
named "g" indicating group numbers.
If \code{distance = TRUE}, a fourth column is added 
which indicates the distances from 
the middle point to other points.
}
\description{
Suppose there is a middle point a, this function 
simultaneous generates points on lines that start 
from a to other points.
}
\examples{
library(ggplot2)
p=c(1, 1, 0, -1, -1, -1, 0, 1)
q=c(0, 1, 1, 1, 0, -1, -1, -1)
pq=data.frame(cbind(p, q))
dat=sunshinexy(outer=pq, n=20, delete_n=5, distance=TRUE)
ggplot()+coord_fixed()+theme_void()+
	geom_point(data=pq, aes(p, q), size=4)+
	geom_line(show.legend=FALSE, data=dat, aes(x, y, group=g, color=distance), size=2)+
	scale_color_continuous(low="blue", high="red")
}
