% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_col_numeric.R
\name{image_col_numeric}
\alias{image_col_numeric}
\title{Colorize an Image according to Gray Scale}
\usage{
image_col_numeric(
  x,
  palette = c("purple", "yellow"),
  n = 256,
  alpha = FALSE,
  result = "magick",
  res = 144
)
}
\arguments{
\item{x}{an image
read into R by \code{magick::image_read}.}

\item{palette}{two or more colors. The default is 
c("purple", "yellow") which means the deeper colors
on the image will become purple and the lighter 
yellow.}

\item{n}{the max num of colors that will be used. 
The default is 256. Note, the number of colors that 
really exist may be smaller than this number.}

\item{alpha}{whether 
transparency is used. Transparency
only exists when \code{alpha = TRUE} and your 
image is in the format (e. g., png) that supports 
transparency. The default is FALSE.}

\item{result}{if it is "magick" (default), the result 
is a picture of the same type used by package magick.
If it is "raster", the result is a matrix that can be 
used as a raster by \code{ggplot2::annotation_raster}.}

\item{res}{resolution that is used by 
\code{magick::image_graph}. The default is 144.}
}
\description{
A color image can be converted to one with 
different degrees of gray. Then, colors in a 
palette can be added according to the gray 
degrees. The function is a simple wrapper 
of \code{scales::col_numeric}.
}
