% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_IMAGE.R
\name{plotly_IMAGE}
\alias{plotly_IMAGE}
\title{Create/Modify plotly images}
\usage{
plotly_IMAGE(x, width = 1000, height = 500, format = "png", scale = 4,
  out_file, ...)
}
\arguments{
\item{x}{either a plotly object or a list.}

\item{width}{Image width in pixels}

\item{height}{Image height in pixels}

\item{format}{The desired image format 'png', 'jpeg', 'svg', 'pdf', 'eps', or 'webp'}

\item{scale}{Both png and jpeg formats will be scaled beyond the specified width and height by this number.}

\item{out_file}{A filename for writing the image to a file.}

\item{...}{arguments passed onto \code{httr::POST}}
}
\description{
The images endpoint turn a plot (which may be given in multiple forms) 
into an image of the desired format.
}
\examples{
\dontrun{

p <- plot_ly(x = 1:10)

Png <- plotly_IMAGE(p, out_file = "plotly-test-image.png")
Jpeg <- plotly_IMAGE(p, format = "jpeg", out_file = "plotly-test-image.jpeg")
Svg <- plotly_IMAGE(p, format = "svg",  out_file = "plotly-test-image.svg")
Pdf <- plotly_IMAGE(p, format = "pdf",  out_file = "plotly-test-image.pdf")
}

}

