% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/message_senders.R
\name{set_scale}
\alias{set_scale}
\title{Set values of a scale}
\usage{
set_scale(
  x,
  id = NULL,
  scale = NULL,
  min = NULL,
  max = NULL,
  breaks = NULL,
  zero = NULL,
  one = NULL,
  direction = NULL,
  mult = NULL,
  default = NULL,
  unfreeze = NULL
)
}
\arguments{
\item{x}{A \code{plotscaper} scene or schema}

\item{id}{A string id of the plot. See \link{id}}

\item{scale}{A string identifying scale. Can be: "x", "y", "area", or "size".}

\item{min}{Scale minimum (continuous scales only)}

\item{max}{Scale maximum (continuous scales only)}

\item{breaks}{A vector of discrete breaks (discrete scale only)}

\item{zero}{The proportion of codomain to which the smallest/first value gets mapped to}

\item{one}{The proportion of codomain to which largest/last value gets mapped to}

\item{direction}{Scale direction. Can be \code{1} or \code{-1}}

\item{mult}{Scale multiplier}

\item{default}{Whether to set other arguments as scale defaults}

\item{unfreeze}{Whether to unfreeze frozen parameters (such as the lower y-axis limit in barplot)}
}
\value{
The scene or schema back
}
\description{
This function sets the values of a scale within one plot
inside a \code{plotscaper} scene or schema.
}
