% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialplot.R
\name{.wrap_spatial_layers}
\alias{.wrap_spatial_layers}
\title{Wrap spatial plot if plotted independently}
\usage{
.wrap_spatial_layers(
  layers,
  ext = NULL,
  flip_y = TRUE,
  legend.position = "right",
  legend.direction = "vertical",
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  theme = "theme_box",
  theme_args = list()
)
}
\arguments{
\item{layers}{A list of ggplot layers to be wrapped.}

\item{ext}{A numeric vector of length 4 specifying the extent as \code{c(xmin, xmax, ymin, ymax)}. Default is NULL.}

\item{flip_y}{Whether to flip the y-axis direction. Default is TRUE.}

\item{legend.position}{The position of the legend. Default is "right".}

\item{legend.direction}{The direction of the legend. Default is "vertical".}

\item{title}{The title of the plot. Default is NULL.}

\item{subtitle}{The subtitle of the plot. Default is NULL.}

\item{xlab}{The x-axis label. Default is NULL.}

\item{ylab}{The y-axis label. Default is NULL.}

\item{theme}{The theme to be used for the plot. Default is "theme_box".}

\item{theme_args}{A list of arguments to be passed to the theme function. Default is an empty list.}
}
\value{
A ggplot object with the specified layers.
}
\description{
This function is used to wrap spatial plots if they are plotted independently
with return_layer = FALSE.
}
\keyword{internal}
